"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _eui = require("@elastic/eui");
var _mime_types = require("../../../common/constants/mime_types");
var _files = require("../../../common/files");
var _use_file_preview = require("./use_file_preview");
var _file_preview = require("./file_preview");
var _use_cases_context = require("../cases_context/use_cases_context");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/files/file_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_ICON = 'paperClip';
const getIcon = mimeType => {
  if (typeof mimeType === 'undefined') {
    return DEFAULT_ICON;
  }
  if (_mime_types.textMimeTypes.includes(mimeType) || _mime_types.pdfMimeTypes.includes(mimeType)) {
    return 'document';
  }
  if (_mime_types.compressionMimeTypes.includes(mimeType)) {
    return 'folderClosed';
  }
  return DEFAULT_ICON;
};
const IMAGE_SIZE = '32px';
const componentStyle = {
  cursor: 'pointer',
  width: IMAGE_SIZE,
  height: IMAGE_SIZE
};
const commonDataTestSubj = 'cases-files-icon';
const FileIcon = exports.FileIcon = /*#__PURE__*/_react.default.memo(({
  file
}) => {
  const {
    isPreviewVisible,
    showPreview,
    closePreview
  } = (0, _use_file_preview.useFilePreview)();
  const {
    client: filesClient
  } = (0, _sharedUxFileContext.useFilesContext)();
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, (0, _utils.isImage)(file) ? /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    src: filesClient.getDownloadHref({
      id: file.id,
      fileKind: (0, _files.constructFileKindIdByOwner)(owner[0])
    }),
    alt: "",
    onClick: showPreview,
    css: componentStyle,
    "data-test-subj": `${commonDataTestSubj}-image`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: getIcon(file.mimeType),
    size: "xl",
    "data-test-subj": commonDataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }), isPreviewVisible && /*#__PURE__*/_react.default.createElement(_file_preview.FilePreview, {
    closePreview: closePreview,
    selectedFile: file,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 30
    }
  }));
});
FileIcon.displayName = 'FileIcon';