"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DropdownFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/renderers/filters/dropdown_filter/component/dropdown_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getMatchAllOptionLabel: () => _i18n.i18n.translate('xpack.canvas.renderer.dropdownFilter.matchAllOptionLabel', {
    defaultMessage: 'ANY',
    description: 'The dropdown filter option to match any value in the field.'
  })
};
const DropdownFilter = ({
  initialValue = '',
  commit,
  choices = []
}) => {
  const [value, setValue] = (0, _react.useState)(initialValue);
  (0, _react.useEffect)(() => {
    setValue(initialValue);
  }, [initialValue]);
  let options = [{
    value: '%%CANVAS_MATCH_ALL%%',
    text: `-- ${strings.getMatchAllOptionLabel()} --`
  }];
  options = options.concat(choices.map(choice => ({
    value: choice[0],
    text: choice[1]
  })));
  const changeHandler = e => {
    if (e && e.target) {
      const target = e.target;
      setValue(target.value);
      commit(target.value);
    }
  };
  const dropdownOptions = options.map(option => {
    const {
      text
    } = option;
    const optionValue = option.value;
    const selected = optionValue === value;
    return {
      text,
      selected,
      value: optionValue
    };
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasDropdownFilter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    className: "canvasDropdownFilter__select",
    value: value,
    onChange: changeHandler,
    "data-test-subj": "canvasDropdownFilter__select",
    options: dropdownOptions,
    fullWidth: true,
    compressed: true,
    "aria-label": _i18n.i18n.translate('xpack.canvas.renderer.dropdownFilter.selectAriaLabel', {
      defaultMessage: 'Dropdown filter'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }));
};
exports.DropdownFilter = DropdownFilter;
DropdownFilter.propTypes = {
  choices: _propTypes.default.array,
  initialValue: _propTypes.default.string,
  commit: _propTypes.default.func.isRequired
};