"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OrphanItemTooltipIcon = OrphanItemTooltipIcon;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/orphan_item_tooltip_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function OrphanItemTooltipIcon({
  docType
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    title: _i18n.i18n.translate('xpack.apm.waterfallItem.euiToolTip.orphanLabel', {
      defaultMessage: 'Orphan'
    }),
    content: _i18n.i18n.translate('xpack.apm.waterfallItem.euiToolTip.orphanDescriotion', {
      defaultMessage: 'This {type} was initially orphaned due to missing trace context but has been reparented to the root transaction to restore the execution flow',
      values: {
        type: docType
      }
    }),
    type: "unlink",
    size: "s",
    color: "danger",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  });
}