"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TraceList = TraceList;
exports.getTraceListColumns = getTraceListColumns;
var _eui = require("@elastic/eui");
var _ebtTools = require("@kbn/ebt-tools");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_apm_router = require("../../../hooks/use_apm_router");
var _formatters = require("../../../../common/utils/formatters");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _style = require("../../../utils/style");
var _empty_message = require("../../shared/empty_message");
var _impact_bar = require("../../shared/impact_bar");
var _transaction_detail_link = require("../../shared/links/apm/transaction_detail_link");
var _managed_table = require("../../shared/managed_table");
var _service_link = require("../../shared/links/apm/service_link");
var _truncate_with_tooltip = require("../../shared/truncate_with_tooltip");
var _i18n2 = require("../../../../common/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/top_traces_overview/trace_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledTransactionLink = (0, _styled.default)(_transaction_detail_link.TransactionDetailLink)`
  font-size: ${() => (0, _eui.useEuiFontSize)('s').fontSize};
  ${(0, _style.truncate)('100%')};
`;
function getTraceListColumns({
  query,
  link
}) {
  return [{
    field: 'transactionName',
    name: _i18n.i18n.translate('xpack.apm.tracesTable.nameColumnLabel', {
      defaultMessage: 'Name'
    }),
    width: '40%',
    sortable: true,
    render: (_, {
      serviceName,
      transactionName,
      transactionType
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: transactionName,
      anchorClassName: "eui-textTruncate",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(StyledTransactionLink, {
      transactionName: transactionName,
      href: link('/services/{serviceName}/transactions/view', {
        path: {
          serviceName
        },
        query: {
          ...query,
          transactionName,
          transactionType,
          serviceGroup: '',
          showCriticalPath: false
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }, transactionName))
  }, {
    field: 'serviceName',
    name: _i18n.i18n.translate('xpack.apm.tracesTable.originatingServiceColumnLabel', {
      defaultMessage: 'Originating service'
    }),
    sortable: true,
    render: (_, {
      serviceName,
      agentName,
      transactionType
    }) => /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
      "data-test-subj": "apmTraceListAppLink",
      text: serviceName || _i18n2.NOT_AVAILABLE_LABEL,
      content: /*#__PURE__*/_react.default.createElement(_service_link.ServiceLink, {
        agentName: agentName,
        query: {
          ...query,
          transactionType,
          serviceGroup: ''
        },
        serviceName: serviceName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 13
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 9
      }
    })
  }, {
    field: 'averageResponseTime',
    name: _i18n.i18n.translate('xpack.apm.tracesTable.avgResponseTimeColumnLabel', {
      defaultMessage: 'Latency (avg.)'
    }),
    sortable: true,
    dataType: 'number',
    render: (_, {
      averageResponseTime
    }) => (0, _formatters.asMillisecondDuration)(averageResponseTime)
  }, {
    field: 'transactionsPerMinute',
    name: _i18n.i18n.translate('xpack.apm.tracesTable.tracesPerMinuteColumnLabel', {
      defaultMessage: 'Traces per minute'
    }),
    sortable: true,
    dataType: 'number',
    render: (_, {
      transactionsPerMinute
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
      "aria-hidden": "true",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 11
      }
    }, (0, _formatters.asTransactionRate)(transactionsPerMinute)), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 13
      }
    }, (0, _formatters.asTransactionValue)(transactionsPerMinute), ' ', _i18n.i18n.translate('xpack.apm.tracesTable.tracesPerMinuteColumn.screenReaderAbbreviation', {
      defaultMessage: 'traces per minute'
    }))))
  }, {
    field: 'impact',
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.apm.tracesTable.impactColumnDescription', {
        defaultMessage: 'The most used and slowest endpoints in your service. Calculated by multiplying latency by throughput.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.tracesTable.impactColumnLabel', {
      defaultMessage: 'Impact'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 13
      }
    }))),
    align: _eui.RIGHT_ALIGNMENT,
    sortable: true,
    render: (_, {
      impact
    }) => /*#__PURE__*/_react.default.createElement(_impact_bar.ImpactBar, {
      value: impact,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 34
      }
    })
  }];
}
const noItemsMessage = /*#__PURE__*/_react.default.createElement(_empty_message.EmptyMessage, {
  heading: _i18n.i18n.translate('xpack.apm.tracesTable.notFoundLabel', {
    defaultMessage: 'No traces found for this query'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 171,
    columnNumber: 3
  }
});
function TraceList({
  response
}) {
  const {
    data: {
      items
    } = {
      items: []
    },
    status
  } = response;
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const {
    query,
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/traces');
  const {
    link
  } = (0, _use_apm_router.useApmRouter)();
  const traceListColumns = (0, _react.useMemo)(() => getTraceListColumns({
    query,
    link
  }), [query, link]);
  (0, _react.useEffect)(() => {
    if (status === _use_fetcher.FETCH_STATUS.SUCCESS) {
      onPageReady({
        meta: {
          rangeFrom,
          rangeTo
        }
      });
    }
  }, [status, onPageReady, rangeFrom, rangeTo]);
  return /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    isLoading: status === _use_fetcher.FETCH_STATUS.LOADING,
    error: status === _use_fetcher.FETCH_STATUS.FAILURE,
    columns: traceListColumns,
    items: items,
    initialSortField: "impact",
    initialSortDirection: "desc",
    noItemsMessage: noItemsMessage,
    initialPageSize: 25,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 5
    }
  });
}