"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiPagination = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _pagination_button = require("./pagination_button");
var _i18n = require("../i18n");
var _text = require("../text");
var _pagination_button_arrow = require("./pagination_button_arrow");
var _services = require("../../services");
var _accessibility = require("../accessibility");
var _pagination = require("./pagination.styles");
var _react2 = require("@emotion/react");
var _excluded = ["className", "pageCount", "activePage", "onPageClick", "compressed", "aria-controls", "responsive"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var MAX_VISIBLE_PAGES = 5;
var NUMBER_SURROUNDING_PAGES = Math.floor(MAX_VISIBLE_PAGES * 0.5);
var EuiPagination = exports.EuiPagination = function EuiPagination(_ref) {
  var className = _ref.className,
    _ref$pageCount = _ref.pageCount,
    pageCount = _ref$pageCount === void 0 ? 1 : _ref$pageCount,
    _ref$activePage = _ref.activePage,
    activePage = _ref$activePage === void 0 ? 0 : _ref$activePage,
    _ref$onPageClick = _ref.onPageClick,
    onPageClick = _ref$onPageClick === void 0 ? function () {} : _ref$onPageClick,
    _compressed = _ref.compressed,
    ariaControls = _ref['aria-controls'],
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isResponsive = (0, _services.useIsWithinBreakpoints)(responsive, !!responsive);
  var euiTheme = (0, _services.useEuiTheme)();
  var styles = (0, _pagination.euiPaginationStyles)(euiTheme);

  // Force to `compressed` version if specified or within the responsive breakpoints
  var compressed = _compressed || isResponsive;
  var safeClick = function safeClick(e, pageIndex) {
    e.preventDefault();
    if (ariaControls) {
      var controlledElement = document.getElementById(ariaControls);
      if (controlledElement) {
        controlledElement.focus();
      }
    }
    onPageClick(pageIndex);
  };
  var classes = (0, _classnames.default)('euiPagination', className);
  var firstButton = (pageCount < 1 || compressed) && (0, _react2.jsx)(_pagination_button_arrow.EuiPaginationButtonArrow, {
    type: "first",
    ariaControls: ariaControls,
    onClick: function onClick(e) {
      return safeClick(e, 0);
    },
    disabled: activePage === 0
  });
  var previousButton = (0, _react2.jsx)(_pagination_button_arrow.EuiPaginationButtonArrow, {
    type: "previous",
    ariaControls: ariaControls,
    onClick: function onClick(e) {
      return safeClick(e, activePage - 1);
    },
    disabled: activePage === 0
  });
  var nextButton = (0, _react2.jsx)(_pagination_button_arrow.EuiPaginationButtonArrow, {
    type: "next",
    ariaControls: ariaControls,
    onClick: function onClick(e) {
      return safeClick(e, activePage + 1);
    },
    disabled: activePage === -1 || activePage === pageCount - 1
  });
  var lastButton = (pageCount < 1 || compressed) && (0, _react2.jsx)(_pagination_button_arrow.EuiPaginationButtonArrow, {
    type: "last",
    ariaControls: ariaControls,
    onClick: function onClick(e) {
      return safeClick(e, pageCount ? pageCount - 1 : -1);
    },
    disabled: activePage === -1 || activePage === pageCount - 1
  });
  var centerPageCount;
  if (pageCount) {
    var sharedButtonProps = {
      activePage: activePage,
      ariaControls: ariaControls,
      safeClick: safeClick,
      pageCount: pageCount
    };
    if (compressed) {
      centerPageCount = (0, _react2.jsx)(_text.EuiText, {
        size: "s",
        css: styles.euiPagination__compressedText,
        className: "euiPagination__compressedText"
      }, (0, _react2.jsx)(_i18n.EuiI18n, {
        token: "euiPagination.pageOfTotalCompressed",
        default: "{page} of {total}",
        values: {
          page: (0, _react2.jsx)("span", {
            key: "activePage"
          }, activePage + 1),
          total: (0, _react2.jsx)("span", {
            key: "pageCount"
          }, pageCount)
        }
      }));
    } else {
      var pages = [];
      var firstPageInRange = Math.max(0, Math.min(activePage - NUMBER_SURROUNDING_PAGES, pageCount - MAX_VISIBLE_PAGES));
      var lastPageInRange = Math.min(pageCount, firstPageInRange + MAX_VISIBLE_PAGES);
      for (var i = firstPageInRange, index = 0; i < lastPageInRange; i++, index++) {
        pages.push((0, _react2.jsx)(PaginationButtonWrapper, _extends({
          pageIndex: i,
          key: i
        }, sharedButtonProps)));
      }
      var firstPageButtons = [];
      if (firstPageInRange > 0) {
        firstPageButtons.push((0, _react2.jsx)(PaginationButtonWrapper, _extends({
          pageIndex: 0,
          key: 0
        }, sharedButtonProps)));
        if (firstPageInRange > 1 && firstPageInRange !== 2) {
          firstPageButtons.push((0, _react2.jsx)(_i18n.EuiI18n, {
            key: "startingEllipses",
            token: "euiPagination.firstRangeAriaLabel",
            default: "Skipping pages 2 to {lastPage}",
            values: {
              lastPage: firstPageInRange
            }
          }, function (firstRangeAriaLabel) {
            return (0, _react2.jsx)("li", {
              "aria-label": firstRangeAriaLabel,
              className: "euiPagination__item",
              css: styles.euiPagination__ellipsis
            }, "\u2026");
          }));
        } else if (firstPageInRange === 2) {
          firstPageButtons.push((0, _react2.jsx)(PaginationButtonWrapper, _extends({
            pageIndex: 1,
            key: 1
          }, sharedButtonProps)));
        }
      }
      var lastPageButtons = [];
      if (lastPageInRange < pageCount) {
        if (lastPageInRange + 1 === pageCount - 1) {
          lastPageButtons.push((0, _react2.jsx)(PaginationButtonWrapper, _extends({
            pageIndex: lastPageInRange,
            key: lastPageInRange
          }, sharedButtonProps)));
        } else if (lastPageInRange < pageCount - 1) {
          lastPageButtons.push((0, _react2.jsx)(_i18n.EuiI18n, {
            key: "endingEllipses",
            token: "euiPagination.lastRangeAriaLabel",
            default: "Skipping pages {firstPage} to {lastPage}",
            values: {
              firstPage: lastPageInRange + 1,
              lastPage: pageCount - 1
            }
          }, function (lastRangeAriaLabel) {
            return (0, _react2.jsx)("li", {
              "aria-label": lastRangeAriaLabel,
              className: "euiPagination__item",
              css: styles.euiPagination__ellipsis
            }, "\u2026");
          }));
        }
        lastPageButtons.push((0, _react2.jsx)(PaginationButtonWrapper, _extends({
          pageIndex: pageCount - 1,
          key: pageCount - 1
        }, sharedButtonProps)));
      }
      var selectablePages = pages;
      centerPageCount = (0, _react2.jsx)("ul", {
        className: "euiPagination__list",
        css: styles.euiPagination__list
      }, firstPageButtons, selectablePages, lastPageButtons);
    }
  }

  // All the i18n strings used to build the whole SR-only text
  var lastLabel = (0, _i18n.useEuiI18n)('euiPagination.last', 'Last');
  var pageLabel = (0, _i18n.useEuiI18n)('euiPagination.page', 'Page');
  var ofLabel = (0, _i18n.useEuiI18n)('euiPagination.of', 'of');
  var collectionLabel = (0, _i18n.useEuiI18n)('euiPagination.collection', 'collection');
  var fromEndLabel = (0, _i18n.useEuiI18n)('euiPagination.fromEndLabel', 'from end');

  // Based on the `activePage` count, build the front of the SR-only text
  // i.e. `Page 1`, `Page 2 from end`, `Last Page`
  var accessiblePageString = function accessiblePageString() {
    if (activePage < -1) return "".concat(pageLabel, " ").concat(Math.abs(activePage), " ").concat(fromEndLabel);
    if (activePage === -1) return "".concat(lastLabel, " ").concat(pageLabel);
    return "".concat(pageLabel, " ").concat(activePage + 1);
  };

  // If `pageCount` is unknown call it `collection`
  var accessibleCollectionString = pageCount === 0 ? collectionLabel : pageCount.toString();

  // Create the whole string with total pageCount or `collection`
  var accessiblePageCount = "".concat(accessiblePageString(), " ").concat(ofLabel, " ").concat(accessibleCollectionString);
  return (0, _react2.jsx)("nav", _extends({
    css: styles.euiPagination,
    className: classes
  }, rest), (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", {
    "aria-atomic": "true",
    "aria-relevant": "additions text",
    role: "status"
  }, accessiblePageCount)), firstButton, previousButton, centerPageCount, nextButton, lastButton);
};
EuiPagination.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
     * The total number of pages.
     * Pass `0` if total count is unknown.
     */
  pageCount: _propTypes.default.number,
  /**
     * The current page using a zero based index.
     * So if you set the activePage to 1, it will activate the second page.
     * Pass `-1` for forcing to last page.
     */
  activePage: _propTypes.default.number,
  /**
     * Click handler that passes back the internally calculated `activePage` index
     */
  onPageClick: _propTypes.default.func,
  /**
     * If true, will only show next/prev arrows and simplified number set.
     */
  compressed: _propTypes.default.bool,
  /**
     * If passed in, passes value through to each button to set aria-controls.
     */
  "aria-controls": _propTypes.default.string,
  /**
     * Automatically reduces to the `compressed` version on smaller screens.
     * Remove completely with `false` or provide your own list of responsive breakpoints.
     */
  responsive: _propTypes.default.oneOfType([_propTypes.default.oneOf([false]), _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired])
};
var PaginationButtonWrapper = function PaginationButtonWrapper(_ref2) {
  var pageIndex = _ref2.pageIndex,
    _ref2$inList = _ref2.inList,
    inList = _ref2$inList === void 0 ? true : _ref2$inList,
    activePage = _ref2.activePage,
    pageCount = _ref2.pageCount,
    ariaControls = _ref2.ariaControls,
    safeClick = _ref2.safeClick,
    disabled = _ref2.disabled;
  var button = (0, _react2.jsx)(_pagination_button.EuiPaginationButton, {
    isActive: pageIndex === activePage,
    totalPages: pageCount,
    onClick: function onClick(e) {
      return safeClick(e, pageIndex);
    },
    pageIndex: pageIndex,
    "aria-controls": ariaControls,
    disabled: disabled
  });
  if (inList) {
    return (0, _react2.jsx)("li", {
      className: "euiPagination__item"
    }, button);
  }
  return button;
};