"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFilterGroupStyles = void 0;
var _react = require("@emotion/react");
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
var _form = require("../form/form.styles");
var _filter_button = require("./filter_button.styles");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _ref = process.env.NODE_ENV === "production" ? {
  name: "ejknuq-fullWidth",
  styles: "display:flex;label:fullWidth;"
} : {
  name: "ejknuq-fullWidth",
  styles: "display:flex;label:fullWidth;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiFilterGroupStyles = exports.euiFilterGroupStyles = function euiFilterGroupStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'buttonVariant');
  var _euiFormVariables = (0, _form.euiFormVariables)(euiThemeContext),
    backgroundColor = _euiFormVariables.backgroundColor,
    borderColor = _euiFormVariables.borderColor,
    controlBorderRadius = _euiFormVariables.controlBorderRadius,
    controlHeight = _euiFormVariables.controlHeight,
    controlCompressedBorderRadius = _euiFormVariables.controlCompressedBorderRadius,
    controlCompressedHeight = _euiFormVariables.controlCompressedHeight;
  var borderRadius = isRefreshVariant ? euiTheme.border.radius.small : controlBorderRadius;
  var borderRadiusCompressed = isRefreshVariant ? euiTheme.border.radius.small : controlCompressedBorderRadius;
  var borderStyle = isRefreshVariant ? "\n      /* Adds the border on a pseudo element to prevent height differences between wrapper and buttons.\n      Uses ::after to ensure overlap and prevents blocking by setting pointer-events: none */\n      &::after {\n        content: '';\n        position: absolute;\n        inset: 0;\n        border: ".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.colors.borderBasePlain, ";\n        border-radius: inherit;\n        pointer-events: none;\n      }\n    ") : "\n      ".concat((0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
    none: "box-shadow: inset 0 0 0 ".concat(euiTheme.border.width.thin, " ").concat(borderColor, ";"),
    forced: "border: ".concat(euiTheme.border.thin, ";")
  }), "\n    ");
  return {
    euiFilterGroup: /*#__PURE__*/(0, _react.css)(isRefreshVariant && "position: relative;", " display:inline-flex;", (0, _global_styling.logicalCSS)('max-width', '100%'), " overflow:hidden;background-color:", backgroundColor, ";", borderStyle, ">*:not(.euiFilterButton__wrapper, .euiFilterButton){", (0, _filter_button.euiFilterButtonDisplay)(euiThemeContext), ";}.euiPopover>.euiFilterButton{", (0, _global_styling.logicalCSS)('width', '100%'), ";}", (0, _global_styling.euiBreakpoint)(euiThemeContext, ['xs', 's']), "{flex-wrap:wrap;}", (0, _global_styling.euiBreakpoint)(euiThemeContext, ['xs']), "{display:flex;", isRefreshVariant && "\n          .euiPopover:focus-within {\n            z-index: 1;\n          }\n            \n          .euiFilterButton__wrapper {\n            flex-grow: 1;\n          }\n        ", ";.euiFilterButton__wrapper{flex-grow:1;}};label:euiFilterGroup;"),
    fullWidth: _ref,
    uncompressed: /*#__PURE__*/(0, _react.css)("border-radius:", borderRadius, ";.euiFilterButton__wrapper{", (0, _global_styling.logicalCSS)('height', controlHeight), ";}.euiFilterButton{", (0, _global_styling.logicalCSS)('height', controlHeight), ";}", !isRefreshVariant && buttonChildrenBorderRadii(borderRadius), " ", isRefreshVariant && "\n        .euiFilterButton-isToggle {\n          ".concat((0, _global_styling.logicalCSS)('height', (0, _global_styling.mathWithUnits)([controlHeight, euiTheme.size.xxs], function (x, y) {
      return x - 3 * y;
    })), "\n        }\n      "), ";;label:uncompressed;"),
    compressed: /*#__PURE__*/(0, _react.css)("border-radius:", borderRadiusCompressed, ";", !isRefreshVariant && buttonChildrenBorderRadii(borderRadiusCompressed), " .euiFilterButton{", (0, _global_styling.logicalCSS)('height', isRefreshVariant ? (0, _global_styling.mathWithUnits)([controlCompressedHeight, euiTheme.border.width.thin], function (x, y) {
      return x - 2 * y;
    }) : controlCompressedHeight), ";}", isRefreshVariant && "\n        .euiFilterButton-isToggle {\n          ".concat((0, _global_styling.logicalCSS)('height', (0, _global_styling.mathWithUnits)([controlCompressedHeight, euiTheme.size.xxs], function (x, y) {
      return x - 3 * y;
    })), "\n        }\n      "), ";;label:compressed;"),
    /**
     * Not used in EuiFilterGroup directly, but used by EuiSearchBar and consumers
     * A fixed width is required because of the shift in widths that can be caused
     * by the loading animation that precedes the results.
     */
    euiFilterGroup__popoverPanel: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSS)('width', (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 18;
    })), ";;label:euiFilterGroup__popoverPanel;")
  };
};

/**
 * Small util for manually rounding the borders of the first and last EuiFilterButtons
 * - this makes their focus rings appear nicely instead of being cutt off.
 * 2nd selector accounts for EuiFilterButtons nested within popover/tooltip wrappers.
 *
 * NOTE: Do not use `logicalShorthandCSS()` here, as that will cause single buttons to not be rounded
 */
var buttonChildrenBorderRadii = function buttonChildrenBorderRadii(radiusSize) {
  return "\n  > :first-child,\n  > :first-child .euiFilterButton {\n    ".concat((0, _global_styling.logicalCSS)('border-top-left-radius', radiusSize), "\n    ").concat((0, _global_styling.logicalCSS)('border-bottom-left-radius', radiusSize), "\n  }\n\n  > :last-child,\n  > :last-child .euiFilterButton {\n    ").concat((0, _global_styling.logicalCSS)('border-top-right-radius', radiusSize), "\n    ").concat((0, _global_styling.logicalCSS)('border-bottom-right-radius', radiusSize), "\n  }\n");
};