"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricTiles = exports.MetricTile = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lib = require("../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/apps/browser-internal/src/status/components/metric_tiles.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/*
 * Displays metadata for a metric.
 */
const MetricCardFooter = ({
  title,
  description
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "serverMetricMeta",
    title: title,
    titleSize: "xxs",
    description: description,
    reverse: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  });
};
const DelayMetricTile = ({
  metric
}) => {
  const {
    name,
    meta
  } = metric;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": `serverMetric-${formatMetricId(name)}`,
    title: formatMetric(metric),
    textAlign: "left",
    description: `${name} avg`,
    footer: (meta === null || meta === void 0 ? void 0 : meta.value) && /*#__PURE__*/_react.default.createElement(MetricCardFooter, {
      title: formatDelayFooterTitle(meta.value, meta.type),
      description: meta.description,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  });
};
const LoadMetricTile = ({
  metric
}) => {
  const {
    name,
    meta
  } = metric;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": `serverMetric-${formatMetricId(name)}`,
    title: formatMetric(metric),
    textAlign: "left",
    description: name,
    footer: meta && /*#__PURE__*/_react.default.createElement(MetricCardFooter, {
      title: meta.title,
      description: meta.description,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 23
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  });
};
const ResponseTimeMetric = ({
  metric
}) => {
  const {
    name,
    meta
  } = metric;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": `serverMetric-${formatMetricId(name)}`,
    title: formatMetric(metric),
    textAlign: "left",
    description: name,
    footer: (meta === null || meta === void 0 ? void 0 : meta.value) && Array.isArray(meta.value) && /*#__PURE__*/_react.default.createElement(MetricCardFooter, {
      title: (0, _lib.formatNumber)(meta.value[0], meta.type),
      description: meta.description,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  });
};

/*
 * Displays a metric with the correct format.
 */
const MetricTile = ({
  metric
}) => {
  const {
    name
  } = metric;
  switch (name) {
    case 'Delay':
      return /*#__PURE__*/_react.default.createElement(DelayMetricTile, {
        metric: metric,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 14
        }
      });
    case 'Load':
      return /*#__PURE__*/_react.default.createElement(LoadMetricTile, {
        metric: metric,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 14
        }
      });
    case 'Response time avg':
      return /*#__PURE__*/_react.default.createElement(ResponseTimeMetric, {
        metric: metric,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 14
        }
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
        "data-test-subj": `serverMetric-${formatMetricId(name)}`,
        textAlign: "left",
        title: formatMetric(metric),
        description: name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 9
        }
      });
  }
};

/*
 * Wrapper component that simply maps each metric to MetricTile inside a FlexGroup
 */
exports.MetricTile = MetricTile;
const MetricTiles = ({
  metrics
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
  columns: 3,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 116,
    columnNumber: 3
  }
}, metrics.map(metric => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  key: metric.name,
  "data-test-subj": "serverMetric",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 118,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(MetricTile, {
  metric: metric,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 119,
    columnNumber: 9
  }
}))));

// formatting helper functions
exports.MetricTiles = MetricTiles;
const formatMetric = ({
  value,
  type
}) => {
  const metrics = Array.isArray(value) ? value : [value];
  return metrics.map(metric => (0, _lib.formatNumber)(metric, type)).join(', ');
};
const formatMetricId = name => {
  return name.toLowerCase().replace(/[ ]+/g, '-');
};
const formatDelayFooterTitle = (values, type) => {
  return `
  50: ${(0, _lib.formatNumber)(values[0], type)};
  95: ${(0, _lib.formatNumber)(values[1], type)};
  99: ${(0, _lib.formatNumber)(values[2], type)}`;
};