"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditObservableModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _observable_form = require("./observable_form");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_patch_observables = require("../../containers/use_patch_observables");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/observables/edit_observable_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EditObservableModal = ({
  onCloseModal: closeModal,
  observable,
  caseData
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    isLoading,
    mutateAsync: patchObservable
  } = (0, _use_patch_observables.usePatchObservable)(caseData.id, observable.id);
  const handleUpdateObservable = async updatedObservable => {
    patchObservable({
      observable: updatedObservable
    });
    closeModal();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "case-observables-edit-modal",
    onClose: closeModal,
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, i18n.EDIT_OBSERVABLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_observable_form.ObservableForm, {
    onCancel: closeModal,
    observable: observable,
    isLoading: isLoading,
    onSubmit: handleUpdateObservable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  })));
};
exports.EditObservableModal = EditObservableModal;
EditObservableModal.displayName = 'EditObservableModal';