"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactShortcuts = require("react-shortcuts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _i18n2 = require("../../../i18n");
var _tool_tip_shortcut = require("../tool_tip_shortcut");
var _refresh_control = require("./refresh_control");
var _fullscreen_control = require("./fullscreen_control");
var _edit_menu = require("./edit_menu");
var _element_menu = require("./element_menu");
var _share_menu = require("./share_menu");
var _view_menu = require("./view_menu");
var _labs_control = require("./labs_control");
var _editor_menu = require("./editor_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/workpad_header.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error no @types definition
// @ts-expect-error untyped local
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getQuickCreateButtonGroupLegend: () => _i18n.i18n.translate('xpack.canvas.workpadHeader.quickCreateButtonGroupLegend', {
    defaultMessage: 'Shortcuts to popular element types'
  }),
  getFullScreenButtonAriaLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeader.fullscreenButtonAriaLabel', {
    defaultMessage: 'View fullscreen'
  }),
  getFullScreenTooltip: () => _i18n.i18n.translate('xpack.canvas.workpadHeader.fullscreenTooltip', {
    defaultMessage: 'Enter fullscreen mode'
  }),
  getHideEditControlTooltip: () => _i18n.i18n.translate('xpack.canvas.workpadHeader.hideEditControlTooltip', {
    defaultMessage: 'Hide editing controls'
  }),
  getNoWritePermissionTooltipText: () => _i18n.i18n.translate('xpack.canvas.workpadHeader.noWritePermissionTooltip', {
    defaultMessage: "You don't have permission to edit this workpad"
  }),
  getShowEditControlTooltip: () => _i18n.i18n.translate('xpack.canvas.workpadHeader.showEditControlTooltip', {
    defaultMessage: 'Show editing controls'
  })
};
const elementStrings = (0, _i18n2.getElementStrings)();
const WorkpadHeader = ({
  isWriteable,
  canUserWrite,
  commit,
  onSetWriteable = () => {},
  renderEmbedPanel,
  elements,
  addElement
}) => {
  const [isEmbedPanelVisible, setEmbedPanelVisible] = (0, _react.useState)(false);
  const hideEmbedPanel = () => setEmbedPanelVisible(false);
  const showEmbedPanel = () => setEmbedPanelVisible(true);
  const toggleWriteable = () => onSetWriteable(!isWriteable);
  const keyHandler = action => {
    if (action === 'EDITING') {
      toggleWriteable();
    }
  };
  const fullscreenButton = ({
    toggleFullscreen
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    }, strings.getFullScreenTooltip(), ' ', /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
      namespace: "PRESENTATION",
      action: "FULLSCREEN",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "fullScreen",
    "aria-label": strings.getFullScreenButtonAriaLabel(),
    onClick: toggleFullscreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }));
  const getEditToggleToolTipText = () => {
    if (!canUserWrite) {
      return strings.getNoWritePermissionTooltipText();
    }
    const content = isWriteable ? strings.getHideEditControlTooltip() : strings.getShowEditControlTooltip();
    return content;
  };
  const getEditToggleToolTip = ({
    textOnly
  } = {
    textOnly: false
  }) => {
    const content = getEditToggleToolTipText();
    if (textOnly) {
      return content;
    }
    return /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    }, content, " ", /*#__PURE__*/_react.default.createElement(_tool_tip_shortcut.ToolTipShortcut, {
      namespace: "EDITOR",
      action: "EDITING",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 19
      }
    }));
  };
  const createElement = (0, _react.useCallback)(elementName => () => {
    const elementSpec = elements[elementName];
    if (elementSpec) {
      addElement(elements[elementName]);
    }
  }, [addElement, elements]);
  const quickButtons = [{
    iconType: 'visText',
    label: elementStrings.markdown.displayName,
    onClick: createElement('markdown')
  }, {
    iconType: 'node',
    label: elementStrings.shape.displayName,
    onClick: createElement('shape')
  }, {
    iconType: 'image',
    label: elementStrings.image.displayName,
    onClick: createElement('image')
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    className: "canvasLayout__stageHeaderInner",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }, isWriteable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.Toolbar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  }, {
    primaryButton: /*#__PURE__*/_react.default.createElement(_element_menu.ElementMenu, {
      addElement: addElement,
      elements: elements,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 32
      }
    }),
    iconButtonGroup: /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.IconButtonGroup, {
      buttons: quickButtons,
      legend: strings.getQuickCreateButtonGroupLegend(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 19
      }
    }),
    extraButtons: [/*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.AddFromLibraryButton, {
      onClick: showEmbedPanel,
      "data-test-subj": "canvas-add-from-library-button",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_editor_menu.EditorMenu, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 19
      }
    })]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_view_menu.ViewMenu, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 15
    }
  })), isWriteable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_edit_menu.EditMenu, {
    commit: commit,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_share_menu.ShareMenu, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_labs_control.LabsControl, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 13
    }
  }, canUserWrite && /*#__PURE__*/_react.default.createElement(_reactShortcuts.Shortcuts, {
    name: "EDITOR",
    handler: keyHandler,
    targetNodeSelector: "body",
    global: true,
    isolate: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: getEditToggleToolTip(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isWriteable ? 'eyeClosed' : 'eye',
    onClick: toggleWriteable,
    size: "s",
    "aria-label": getEditToggleToolTipText(),
    isDisabled: !canUserWrite,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_refresh_control.RefreshControl, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_fullscreen_control.FullscreenControl, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 15
    }
  }, fullscreenButton))))), isEmbedPanelVisible ? renderEmbedPanel(hideEmbedPanel) : null);
};
exports.WorkpadHeader = WorkpadHeader;
WorkpadHeader.propTypes = {
  isWriteable: _propTypes.default.bool,
  commit: _propTypes.default.func.isRequired,
  onSetWriteable: _propTypes.default.func,
  canUserWrite: _propTypes.default.bool,
  renderEmbedPanel: _propTypes.default.func.isRequired,
  elements: _propTypes.default.object.isRequired,
  addElement: _propTypes.default.func.isRequired
};