"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findExactConfiguration = findExactConfiguration;
var _server = require("@kbn/apm-sources-access-plugin/server");
var _apm = require("../../../../common/es_fields/apm");
var _convert_settings_to_string = require("./convert_settings_to_string");
var _get_agent_config_etag_metrics = require("./get_agent_config_etag_metrics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function findExactConfiguration({
  service,
  internalESClient,
  apmEventClient
}) {
  const serviceNameFilter = service.name ? {
    term: {
      [_apm.SERVICE_NAME]: service.name
    }
  } : {
    bool: {
      must_not: [{
        exists: {
          field: _apm.SERVICE_NAME
        }
      }]
    }
  };
  const environmentFilter = service.environment ? {
    term: {
      [_apm.SERVICE_ENVIRONMENT]: service.environment
    }
  } : {
    bool: {
      must_not: [{
        exists: {
          field: _apm.SERVICE_ENVIRONMENT
        }
      }]
    }
  };
  const params = {
    index: _server.APM_AGENT_CONFIGURATION_INDEX,
    query: {
      bool: {
        filter: [serviceNameFilter, environmentFilter]
      }
    }
  };
  const agentConfig = await internalESClient.search('find_exact_agent_configuration', params);
  const hit = agentConfig.hits.hits[0];
  if (!hit) {
    return;
  }
  const appliedByAgent = await getIsAppliedByAgent({
    apmEventClient,
    agentConfiguration: hit._source
  });
  return {
    id: hit._id,
    ...(0, _convert_settings_to_string.convertConfigSettingsToString)(hit)._source,
    applied_by_agent: appliedByAgent
  };
}
async function getIsAppliedByAgent({
  apmEventClient,
  agentConfiguration
}) {
  if (agentConfiguration.applied_by_agent) {
    return true;
  }
  const appliedEtags = await (0, _get_agent_config_etag_metrics.getAgentConfigEtagMetrics)(apmEventClient, agentConfiguration.etag);
  return appliedEtags.includes(agentConfiguration.etag);
}