"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanLinksBadge = SpanLinksBadge;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/badge/span_links_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SpanLinksBadge({
  linkedParents,
  linkedChildren,
  id,
  onClick
}) {
  if (!linkedParents && !linkedChildren) {
    return null;
  }
  const spanLinksFlyoutTab = 'span_links';
  const total = linkedParents + linkedChildren;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    title: _i18n.i18n.translate('xpack.apm.waterfall.spanLinks.tooltip.title', {
      defaultMessage: '{total} {total, plural, one {Span link} other {Span links}} found',
      values: {
        total
      }
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.waterfall.spanLinks.tooltip.linkedChildren', {
      defaultMessage: '{linkedChildren} incoming',
      values: {
        linkedChildren
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.apm.waterfall.spanLinks.tooltip.linkedParents', {
      defaultMessage: '{linkedParents} outgoing',
      values: {
        linkedParents
      }
    }))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
    tabIndex: 0,
    "data-test-subj": `spanLinksBadge_${id}`
  }, onClick ? {
    onClick: e => {
      e.stopPropagation();
      onClick(spanLinksFlyoutTab);
    },
    onClickAriaLabel: _i18n.i18n.translate('xpack.apm.waterfall.spanLinks.badgeAriaLabel', {
      defaultMessage: 'Open span links details'
    })
  } : [], {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }), _i18n.i18n.translate('xpack.apm.waterfall.spanLinks.badge', {
    defaultMessage: '{total} {total, plural, one {Span link} other {Span links}}',
    values: {
      total
    }
  })));
}