"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = getColumns;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _get_timeseries_color = require("../../../../../shared/charts/helper/get_timeseries_color");
var _spark_plot = require("../../../../../shared/charts/spark_plot");
var _get_comparison_options = require("../../../../../shared/time_comparison/get_comparison_options");
var _formatters = require("../../../../../../../common/utils/formatters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/transaction_overview/transaction_overview_tabs/stats_list/get_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getColumns({
  detailedStatisticsLoading,
  detailedStatistics,
  comparisonEnabled,
  offset
}) {
  return [
  // version/device
  {
    field: 'name',
    name: _i18n.i18n.translate('xpack.apm.mobile.transactions.overview.table.nameColumnLabel', {
      defaultMessage: 'Name'
    })
  },
  // latency
  {
    field: 'latency',
    name: _i18n.i18n.translate('xpack.apm.mobile.transactions.overview.table.latencyColumnAvgLabel', {
      defaultMessage: 'Latency (avg.)'
    }),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      latency,
      name
    }) => {
      var _detailedStatistics$c, _detailedStatistics$c2, _detailedStatistics$p, _detailedStatistics$p2;
      const currentPeriodTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$c = detailedStatistics.currentPeriod) === null || _detailedStatistics$c === void 0 ? void 0 : (_detailedStatistics$c2 = _detailedStatistics$c[name]) === null || _detailedStatistics$c2 === void 0 ? void 0 : _detailedStatistics$c2.latency;
      const previousPeriodTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$p = detailedStatistics.previousPeriod) === null || _detailedStatistics$p === void 0 ? void 0 : (_detailedStatistics$p2 = _detailedStatistics$p[name]) === null || _detailedStatistics$p2 === void 0 ? void 0 : _detailedStatistics$p2.latency;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.LATENCY_AVG);
      return /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
        color: currentPeriodColor,
        isLoading: detailedStatisticsLoading,
        series: currentPeriodTimeseries,
        valueLabel: (0, _formatters.asMillisecondDuration)(latency),
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriodTimeseries : undefined,
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 11
        }
      });
    }
  },
  // throughput
  {
    field: 'throughput',
    name: _i18n.i18n.translate('xpack.apm.mobile.transactions.overview.table.throughputColumnAvgLabel', {
      defaultMessage: 'Throughput'
    }),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      throughput,
      name
    }) => {
      var _detailedStatistics$c3, _detailedStatistics$c4, _detailedStatistics$p3, _detailedStatistics$p4;
      const currentPeriodTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$c3 = detailedStatistics.currentPeriod) === null || _detailedStatistics$c3 === void 0 ? void 0 : (_detailedStatistics$c4 = _detailedStatistics$c3[name]) === null || _detailedStatistics$c4 === void 0 ? void 0 : _detailedStatistics$c4.throughput;
      const previousPeriodTimeseries = detailedStatistics === null || detailedStatistics === void 0 ? void 0 : (_detailedStatistics$p3 = detailedStatistics.previousPeriod) === null || _detailedStatistics$p3 === void 0 ? void 0 : (_detailedStatistics$p4 = _detailedStatistics$p3[name]) === null || _detailedStatistics$p4 === void 0 ? void 0 : _detailedStatistics$p4.throughput;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.THROUGHPUT);
      return /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
        color: currentPeriodColor,
        isLoading: detailedStatisticsLoading,
        series: currentPeriodTimeseries,
        valueLabel: (0, _formatters.asTransactionRate)(throughput),
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriodTimeseries : undefined,
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 11
        }
      });
    }
  },
  // crash rate
  {
    field: 'crashRate',
    name: _i18n.i18n.translate('xpack.apm.mobile.transactions.overview.table.crashRateColumnLabel', {
      defaultMessage: 'Crash rate'
    }),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      crashRate
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        textAlign: "right",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 11
        }
      }, (0, _formatters.asPercent)(crashRate, 1));
    }
  }];
}