"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _dataService = require("@kbn/data-service");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_data_source = require("../../hooks/use_data_source");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/search_panel/search_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchPanel = ({
  searchString,
  searchQueryLanguage,
  setSearchParams
}) => {
  const {
    uiSettings,
    unifiedSearch: {
      ui: {
        SearchBar
      }
    },
    notifications: {
      toasts
    },
    data: {
      query: queryManager
    }
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    dataView
  } = (0, _use_data_source.useDataSource)();

  // The internal state of the input query bar updated on every key stroke.
  const [searchInput, setSearchInput] = (0, _react.useState)({
    query: searchString || '',
    language: searchQueryLanguage
  });
  (0, _react.useEffect)(() => {
    setSearchInput({
      query: searchString || '',
      language: searchQueryLanguage
    });
  }, [searchQueryLanguage, searchString, queryManager.filterManager]);
  const searchHandler = ({
    query,
    filters
  }) => {
    const mergedQuery = query !== null && query !== void 0 ? query : searchInput;
    const mergedFilters = filters !== null && filters !== void 0 ? filters : queryManager.filterManager.getFilters();
    try {
      var _queryManager$filterM;
      if (mergedFilters) {
        queryManager.filterManager.setFilters(mergedFilters);
      }
      const combinedQuery = (0, _esQuery.buildEsQuery)(dataView, mergedQuery, (_queryManager$filterM = queryManager.filterManager.getFilters()) !== null && _queryManager$filterM !== void 0 ? _queryManager$filterM : [], uiSettings ? (0, _dataService.getEsQueryConfig)(uiSettings) : undefined);
      setSearchParams({
        searchQuery: combinedQuery,
        searchString: mergedQuery.query,
        queryLanguage: mergedQuery.language,
        filters: mergedFilters
      });
    } catch (e) {
      console.log('Invalid syntax', JSON.stringify(e, null, 2)); // eslint-disable-line no-console
      toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.aiops.searchPanel.invalidSyntax', {
          defaultMessage: 'Invalid syntax'
        })
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    "data-test-subj": "aiopsSearchPanel",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 9,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SearchBar, {
    dataTestSubj: "aiopsQueryInput",
    appName: 'aiops',
    showFilterBar: true,
    showDatePicker: false,
    showQueryInput: true,
    showSavedQueryControls: false,
    query: searchInput,
    onQuerySubmit: params => searchHandler({
      query: params.query
    }),
    indexPatterns: [dataView],
    placeholder: _i18n.i18n.translate('xpack.aiops.searchPanel.queryBarPlaceholderText', {
      defaultMessage: 'Search… (e.g. status:200 AND extension:"PHP")'
    }),
    displayStyle: 'inPage',
    isClearable: true,
    showSubmitButton: false,
    onFiltersUpdated: filters => searchHandler({
      filters
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  })));
};
exports.SearchPanel = SearchPanel;