"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiPopoverArrowStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _popover = require("../../../services/popover");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiPopoverArrowStyles = exports.euiPopoverArrowStyles = function euiPopoverArrowStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode,
    colorMode = euiThemeContext.colorMode;
  var hasBorder = highContrastMode || colorMode === 'DARK';
  var arrowSize = euiTheme.size.base;
  var arrowStyles = (0, _popover._popoverArrowStyles)(euiThemeContext, arrowSize);
  return _objectSpread({
    // Wrapper
    euiPopoverArrowWrapper: /*#__PURE__*/(0, _react.css)("position:absolute;z-index:1;", (0, _global_styling.logicalSizeCSS)(arrowSize), ";;label:euiPopoverArrowWrapper;"),
    // Base
    euiPopoverArrow: /*#__PURE__*/(0, _react.css)(arrowStyles._arrowStyles, " background-color:var(--euiPopoverBackgroundColor);", hasBorder ? "border: ".concat(euiTheme.border.thin, ";") : '', ";;label:euiPopoverArrow;")
  }, arrowStyles.positions);
};