/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.operator.DriverContext;

public class Warnings {
    static final int MAX_ADDED_WARNINGS = 20;
    public static final Warnings NOOP_WARNINGS = new Warnings(-1, -2, "", ""){

        @Override
        public void registerException(Exception exception) {
        }
    };
    private final String location;
    private final String first;
    private int addedWarnings;

    public static Warnings createWarnings(DriverContext.WarningsMode warningsMode, int lineNumber, int columnNumber, String sourceText) {
        return Warnings.createWarnings(warningsMode, lineNumber, columnNumber, sourceText, "evaluation of [{}] failed, treating result as null");
    }

    public static Warnings createWarningsTreatedAsFalse(DriverContext.WarningsMode warningsMode, int lineNumber, int columnNumber, String sourceText) {
        return Warnings.createWarnings(warningsMode, lineNumber, columnNumber, sourceText, "evaluation of [{}] failed, treating result as false");
    }

    public static Warnings createOnlyWarnings(DriverContext.WarningsMode warningsMode, int lineNumber, int columnNumber, String sourceText) {
        return Warnings.createWarnings(warningsMode, lineNumber, columnNumber, sourceText, "warnings during evaluation of [{}]");
    }

    private static Warnings createWarnings(DriverContext.WarningsMode warningsMode, int lineNumber, int columnNumber, String sourceText, String first) {
        switch (warningsMode) {
            case COLLECT: {
                return new Warnings(lineNumber, columnNumber, sourceText, first);
            }
            case IGNORE: {
                return NOOP_WARNINGS;
            }
        }
        throw new IllegalStateException("Unreachable");
    }

    private Warnings(int lineNumber, int columnNumber, String sourceText, String first) {
        this.location = LoggerMessageFormat.format((String)"Line {}:{}: ", (Object[])new Object[]{lineNumber, columnNumber});
        this.first = LoggerMessageFormat.format(null, (String)("{}" + first + ". Only first {} failures recorded."), (Object[])new Object[]{this.location, sourceText, 20});
    }

    public void registerException(Exception exception) {
        this.registerException(exception.getClass(), exception.getMessage());
    }

    public void registerException(Class<? extends Exception> exceptionClass, String message) {
        if (this.addedWarnings < 20) {
            if (this.addedWarnings == 0) {
                HeaderWarning.addWarning((String)this.first, (Object[])new Object[0]);
            }
            HeaderWarning.addWarning((String)(this.location + exceptionClass.getName() + ": " + message), (Object[])new Object[0]);
            ++this.addedWarnings;
        }
    }
}

