/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateRequest;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.operator.OperatorPrivilegesUtil;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.InternalUser;
import org.elasticsearch.xpack.core.security.user.User;

public class TransportAuthenticateAction
extends HandledTransportAction<AuthenticateRequest, AuthenticateResponse> {
    private final SecurityContext securityContext;
    private final AnonymousUser anonymousUser;

    @Inject
    public TransportAuthenticateAction(TransportService transportService, ActionFilters actionFilters, SecurityContext securityContext, AnonymousUser anonymousUser) {
        super("cluster:admin/xpack/security/user/authenticate", transportService, actionFilters, AuthenticateRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.securityContext = securityContext;
        this.anonymousUser = anonymousUser;
    }

    protected void doExecute(Task task, AuthenticateRequest request, ActionListener<AuthenticateResponse> listener) {
        User runAsUser;
        User authUser;
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            authUser = null;
            runAsUser = null;
        } else {
            runAsUser = authentication.getEffectiveSubject().getUser();
            authUser = authentication.getAuthenticatingSubject().getUser();
        }
        if (authUser == null) {
            listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("did not find an authenticated user", new Object[0])));
        } else if (authUser instanceof InternalUser) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + authUser.principal() + "] is internal"));
        } else if (runAsUser instanceof InternalUser) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + runAsUser.principal() + "] is internal"));
        } else {
            listener.onResponse((Object)new AuthenticateResponse(authentication.maybeAddAnonymousRoles(this.anonymousUser), OperatorPrivilegesUtil.isOperator((ThreadContext)this.securityContext.getThreadContext())));
        }
    }
}

