/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.node.internal.TerminationHandler;
import org.elasticsearch.tasks.TaskManager;

public class ShutdownPrepareService {
    private final Logger logger = LogManager.getLogger(ShutdownPrepareService.class);
    private final Settings settings;
    private final HttpServerTransport httpServerTransport;
    private final TerminationHandler terminationHandler;
    private volatile boolean hasBeenShutdown = false;
    public static final Setting<TimeValue> MAXIMUM_SHUTDOWN_TIMEOUT_SETTING = Setting.positiveTimeSetting("node.maximum_shutdown_grace_period", TimeValue.ZERO, Setting.Property.NodeScope);
    public static final Setting<TimeValue> MAXIMUM_REINDEXING_TIMEOUT_SETTING = Setting.positiveTimeSetting("node.maximum_reindexing_grace_period", TimeValue.timeValueSeconds((long)10L), Setting.Property.NodeScope);

    public ShutdownPrepareService(Settings settings, HttpServerTransport httpServerTransport, TerminationHandler terminationHandler) {
        this.settings = settings;
        this.httpServerTransport = httpServerTransport;
        this.terminationHandler = terminationHandler;
    }

    public void prepareForShutdown(TaskManager taskManager) {
        record Stopper(String name, SubscribableListener<Void> listener) {
            boolean isIncomplete() {
                return !this.listener().isDone();
            }
        }
        assert (!this.hasBeenShutdown);
        this.hasBeenShutdown = true;
        TimeValue maxTimeout = MAXIMUM_SHUTDOWN_TIMEOUT_SETTING.get(this.settings);
        TimeValue reindexTimeout = MAXIMUM_REINDEXING_TIMEOUT_SETTING.get(this.settings);
        ArrayList stoppers = new ArrayList();
        PlainActionFuture<Void> allStoppersFuture = new PlainActionFuture<Void>();
        try (RefCountingListener listeners = new RefCountingListener(allStoppersFuture);){
            BiConsumer<String, Runnable> stopperRunner = (name, action) -> {
                Stopper stopper = new Stopper((String)name, new SubscribableListener<Void>());
                stoppers.add(stopper);
                stopper.listener().addListener(listeners.acquire());
                new Thread(() -> {
                    try {
                        action.run();
                    }
                    catch (Exception ex) {
                        this.logger.warn("unexpected exception in shutdown task [" + stopper.name() + "]", (Throwable)ex);
                    }
                    finally {
                        stopper.listener().onResponse(null);
                    }
                }, stopper.name()).start();
            };
            stopperRunner.accept("http-server-transport-stop", () -> ((HttpServerTransport)this.httpServerTransport).close());
            stopperRunner.accept("async-search-stop", () -> this.awaitSearchTasksComplete(maxTimeout, taskManager));
            stopperRunner.accept("reindex-stop", () -> this.awaitReindexTasksComplete(reindexTimeout, taskManager));
            if (this.terminationHandler != null) {
                stopperRunner.accept("termination-handler-stop", this.terminationHandler::handleTermination);
            }
        }
        Supplier<String> incompleteStoppersDescriber = () -> stoppers.stream().filter(Stopper::isIncomplete).map(Stopper::name).collect(Collectors.joining(", ", "[", "]"));
        try {
            if (TimeValue.ZERO.equals((Object)maxTimeout)) {
                allStoppersFuture.get();
            } else {
                allStoppersFuture.get(maxTimeout.millis(), TimeUnit.MILLISECONDS);
            }
        }
        catch (ExecutionException e) {
            assert (false) : e;
            this.logger.warn("failed during graceful shutdown tasks", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.warn("interrupted while waiting for graceful shutdown tasks: " + incompleteStoppersDescriber.get(), (Throwable)e);
        }
        catch (TimeoutException e) {
            this.logger.warn("timed out while waiting for graceful shutdown tasks: " + incompleteStoppersDescriber.get());
        }
    }

    private void awaitTasksComplete(TimeValue timeout, String taskName, TaskManager taskManager) {
        long millisWaited = 0L;
        while (true) {
            long tasksRemaining;
            if ((tasksRemaining = taskManager.getTasks().values().stream().filter(task -> taskName.equals(task.getAction())).count()) == 0L) {
                this.logger.debug("all " + taskName + " tasks complete");
                return;
            }
            TimeValue pollPeriod = TimeValue.timeValueMillis((long)500L);
            if (!TimeValue.ZERO.equals((Object)timeout) && (millisWaited += pollPeriod.millis()) >= timeout.millis()) {
                this.logger.warn(Strings.format((String)("timed out after waiting [%s] for [%d] " + taskName + " tasks to finish"), (Object[])new Object[]{timeout.toString(), tasksRemaining}));
                return;
            }
            this.logger.debug(Strings.format((String)("waiting for [%s] " + taskName + " tasks to finish, next poll in [%s]"), (Object[])new Object[]{tasksRemaining, pollPeriod}));
            try {
                Thread.sleep(pollPeriod.millis());
            }
            catch (InterruptedException ex) {
                this.logger.warn(Strings.format((String)("interrupted while waiting [%s] for [%d] " + taskName + " tasks to finish"), (Object[])new Object[]{timeout.toString(), tasksRemaining}));
                return;
            }
        }
    }

    private void awaitSearchTasksComplete(TimeValue asyncSearchTimeout, TaskManager taskManager) {
        this.awaitTasksComplete(asyncSearchTimeout, "indices:data/read/search", taskManager);
    }

    private void awaitReindexTasksComplete(TimeValue asyncReindexTimeout, TaskManager taskManager) {
        this.awaitTasksComplete(asyncReindexTimeout, "indices:data/write/reindex", taskManager);
    }
}

