/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.lucene.uid.VersionsAndSeqNoResolver;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.mapper.InferenceMetadataFieldsMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperMetrics;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.MultiEngineGet;
import org.elasticsearch.search.fetch.subphase.FetchFieldsContext;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;

public final class ShardGetService
extends AbstractIndexShardComponent {
    private final MapperService mapperService;
    private final MeanMetric existsMetric = new MeanMetric();
    private final MeanMetric missingMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();
    private final IndexShard indexShard;
    private final MapperMetrics mapperMetrics;

    public ShardGetService(IndexSettings indexSettings, IndexShard indexShard, MapperService mapperService, MapperMetrics mapperMetrics) {
        super(indexShard.shardId(), indexSettings);
        this.mapperService = mapperService;
        this.indexShard = indexShard;
        this.mapperMetrics = mapperMetrics;
    }

    public GetStats stats() {
        return new GetStats(this.existsMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.existsMetric.sum()), this.missingMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.missingMetric.sum()), this.currentMetric.count());
    }

    public GetResult get(String id, String[] gFields, boolean realtime, long version, VersionType versionType, FetchSourceContext fetchSourceContext, boolean forceSyntheticSource) throws IOException {
        return this.doGet(id, gFields, realtime, version, versionType, -2L, 0L, fetchSourceContext, forceSyntheticSource, this.indexShard::get);
    }

    public GetResult mget(String id, String[] gFields, boolean realtime, long version, VersionType versionType, FetchSourceContext fetchSourceContext, boolean forceSyntheticSource, MultiEngineGet mget) throws IOException {
        return this.doGet(id, gFields, realtime, version, versionType, -2L, 0L, fetchSourceContext, forceSyntheticSource, mget::get);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GetResult doGet(String id, String[] gFields, boolean realtime, long version, VersionType versionType, long ifSeqNo, long ifPrimaryTerm, FetchSourceContext fetchSourceContext, boolean forceSyntheticSource, Function<Engine.Get, Engine.GetResult> engineGetOperator) throws IOException {
        this.currentMetric.inc();
        long now = System.nanoTime();
        try {
            GetResult getResult;
            Engine.Get engineGet = new Engine.Get(realtime, realtime, id).version(version).versionType(versionType).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm);
            try (Engine.GetResult get = engineGetOperator.apply(engineGet);){
                getResult = get == null ? null : (!get.exists() ? new GetResult(this.shardId.getIndexName(), id, -2L, 0L, -1L, false, null, null, null) : this.innerGetFetch(id, gFields, ShardGetService.normalizeFetchSourceContent(fetchSourceContext, gFields), get, forceSyntheticSource));
            }
            if (getResult != null && getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    public GetResult getFromTranslog(String id, String[] gFields, boolean realtime, long version, VersionType versionType, FetchSourceContext fetchSourceContext, boolean forceSyntheticSource) throws IOException {
        return this.doGet(id, gFields, realtime, version, versionType, -2L, 0L, fetchSourceContext, forceSyntheticSource, this.indexShard::getFromTranslog);
    }

    public GetResult getForUpdate(String id, long ifSeqNo, long ifPrimaryTerm, FetchSourceContext fetchSourceContext) throws IOException {
        return this.doGet(id, new String[]{"_routing"}, true, -3L, VersionType.INTERNAL, ifSeqNo, ifPrimaryTerm, fetchSourceContext, false, this.indexShard::get);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(Engine.GetResult engineGetResult, String id, String[] fields, FetchSourceContext fetchSourceContext) throws IOException {
        if (!engineGetResult.exists()) {
            return new GetResult(this.shardId.getIndexName(), id, -2L, 0L, -1L, false, null, null, null);
        }
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            fetchSourceContext = ShardGetService.normalizeFetchSourceContent(fetchSourceContext, fields);
            GetResult getResult = this.innerGetFetch(id, fields, fetchSourceContext, engineGetResult, false);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    private static FetchSourceContext normalizeFetchSourceContent(@Nullable FetchSourceContext context, @Nullable String[] gFields) {
        if (context != null) {
            return context;
        }
        if (gFields == null) {
            return FetchSourceContext.FETCH_SOURCE;
        }
        for (String field : gFields) {
            if (!"_source".equals(field)) continue;
            return FetchSourceContext.FETCH_SOURCE;
        }
        return FetchSourceContext.DO_NOT_FETCH_SOURCE;
    }

    private GetResult innerGetFetch(String id, String[] storedFields, FetchSourceContext fetchSourceContext, Engine.GetResult get, boolean forceSyntheticSource) throws IOException {
        DocumentField ignoredDocumentField;
        assert (get.exists()) : "method should only be called if document could be retrieved";
        MappingLookup mappingLookup = this.mapperService.mappingLookup();
        HashSet<String> storedFieldSet = new HashSet<String>();
        if (storedFields != null) {
            for (String field : storedFields) {
                Mapper fieldMapper = mappingLookup.getMapper(field);
                if (fieldMapper == null && mappingLookup.objectMappers().get(field) != null) {
                    throw new IllegalArgumentException("field [" + field + "] isn't a leaf field");
                }
                storedFieldSet.add(field);
            }
        }
        HashMap<String, DocumentField> documentFields = null;
        HashMap<String, DocumentField> metadataFields = null;
        VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion = get.docIdAndVersion();
        Tuple<FetchSourceContext, SourceFilter> res = ShardGetService.maybeExcludeVectorFields(mappingLookup, this.indexSettings, fetchSourceContext, null);
        if (res.v1() != fetchSourceContext) {
            fetchSourceContext = (FetchSourceContext)res.v1();
        }
        if (!mappingLookup.inferenceFields().isEmpty() && !ShardGetService.shouldExcludeInferenceFieldsFromSource(fetchSourceContext)) {
            storedFieldSet.add("_inference_fields");
        }
        SourceFilter sourceFilter = (SourceFilter)res.v2();
        SourceLoader loader = forceSyntheticSource ? new SourceLoader.Synthetic(sourceFilter, () -> mappingLookup.getMapping().syntheticFieldLoader(sourceFilter), this.mapperMetrics.sourceFieldMetrics(), mappingLookup.getMapping().ignoredSourceFormat()) : mappingLookup.newSourceLoader(sourceFilter, this.mapperMetrics.sourceFieldMetrics());
        StoredFieldLoader storedFieldLoader = ShardGetService.buildStoredFieldLoader(storedFieldSet, fetchSourceContext, loader);
        LeafStoredFieldLoader leafStoredFieldLoader = storedFieldLoader.getLoader(docIdAndVersion.reader.getContext(), null);
        try {
            leafStoredFieldLoader.advanceTo(docIdAndVersion.docId);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to get id [" + id + "]", (Throwable)e, new Object[0]);
        }
        boolean supportDocValuesForIgnoredMetaField = this.indexSettings.getIndexVersionCreated().onOrAfter(IndexVersions.DOC_VALUES_FOR_IGNORED_META_FIELD);
        if (!leafStoredFieldLoader.storedFields().isEmpty()) {
            HashSet<String> needed = new HashSet<String>();
            if (storedFields != null) {
                Collections.addAll(needed, storedFields);
            }
            needed.add("_routing");
            documentFields = new HashMap<String, DocumentField>();
            metadataFields = new HashMap<String, DocumentField>();
            for (Map.Entry<String, List<Object>> entry : leafStoredFieldLoader.storedFields().entrySet()) {
                MappedFieldType ft;
                if (!needed.contains(entry.getKey()) || "_ignored".equals(entry.getKey()) && supportDocValuesForIgnoredMetaField || (ft = this.mapperService.fieldType(entry.getKey())) == null) continue;
                List<Object> values = entry.getValue().stream().map(ft::valueForDisplay).toList();
                if (this.mapperService.isMetadataField(entry.getKey())) {
                    metadataFields.put(entry.getKey(), new DocumentField(entry.getKey(), values));
                    continue;
                }
                documentFields.put(entry.getKey(), new DocumentField(entry.getKey(), values));
            }
        }
        if (supportDocValuesForIgnoredMetaField && storedFields != null && Arrays.asList(storedFields).contains("_ignored") && (ignoredDocumentField = ShardGetService.loadIgnoredMetadataField(docIdAndVersion)) != null) {
            if (metadataFields == null) {
                metadataFields = new HashMap();
            }
            metadataFields.put("_ignored", ignoredDocumentField);
        }
        BytesReference sourceBytes = null;
        if (this.mapperService.mappingLookup().isSourceEnabled() && fetchSourceContext.fetchSource()) {
            Source source = loader.leaf(docIdAndVersion.reader, new int[]{docIdAndVersion.docId}).source(leafStoredFieldLoader, docIdAndVersion.docId);
            SourceFilter filter = fetchSourceContext.filter();
            if (filter != null) {
                source = source.filter(filter);
            }
            if (storedFieldSet.contains("_inference_fields")) {
                source = ShardGetService.addInferenceMetadataFields(this.mapperService, docIdAndVersion.reader.getContext(), docIdAndVersion.docId, source);
            }
            sourceBytes = source.internalSourceRef();
        }
        return new GetResult(this.shardId.getIndexName(), id, get.docIdAndVersion().seqNo, get.docIdAndVersion().primaryTerm, get.version(), get.exists(), sourceBytes, documentFields, metadataFields);
    }

    public static boolean shouldExcludeVectorsFromSource(IndexSettings indexSettings, FetchSourceContext fetchSourceContext) {
        Boolean explicit = ShardGetService.shouldExcludeVectorsFromSourceExplicit(fetchSourceContext);
        return explicit != null ? explicit : IndexSettings.INDEX_MAPPING_EXCLUDE_SOURCE_VECTORS_SETTING.get(indexSettings.getSettings());
    }

    private static Boolean shouldExcludeVectorsFromSourceExplicit(FetchSourceContext fetchSourceContext) {
        return fetchSourceContext != null ? fetchSourceContext.excludeVectors() : null;
    }

    public static boolean shouldExcludeInferenceFieldsFromSource(FetchSourceContext fetchSourceContext) {
        if (fetchSourceContext != null) {
            Boolean excludeInferenceFieldsExplicit;
            if (!fetchSourceContext.fetchSource()) {
                return true;
            }
            SourceFilter filter = fetchSourceContext.filter();
            if (filter != null) {
                if (filter.isPathFiltered("_inference_fields", true)) {
                    return true;
                }
                if (filter.isExplicitlyIncluded("_inference_fields")) {
                    return false;
                }
            }
            if ((excludeInferenceFieldsExplicit = ShardGetService.shouldExcludeInferenceFieldsFromSourceExplicit(fetchSourceContext)) != null) {
                return excludeInferenceFieldsExplicit;
            }
        }
        return true;
    }

    private static Boolean shouldExcludeInferenceFieldsFromSourceExplicit(FetchSourceContext fetchSourceContext) {
        return fetchSourceContext != null ? fetchSourceContext.excludeInferenceFields() : null;
    }

    public static Tuple<FetchSourceContext, SourceFilter> maybeExcludeVectorFields(MappingLookup mappingLookup, IndexSettings indexSettings, FetchSourceContext fetchSourceContext, FetchFieldsContext fetchFieldsContext) {
        SourceFilter sourceFilter;
        if (!ShardGetService.shouldExcludeVectorsFromSource(indexSettings, fetchSourceContext)) {
            return Tuple.tuple((Object)fetchSourceContext, null);
        }
        CharacterRunAutomaton fetchFieldsAut = fetchFieldsContext != null && fetchFieldsContext.fields().size() > 0 ? new CharacterRunAutomaton(Regex.simpleMatchToAutomaton((String[])fetchFieldsContext.fields().stream().map(f -> f.field).toArray(String[]::new))) : null;
        CharacterRunAutomaton inferenceFieldsAut = mappingLookup.inferenceFields().size() > 0 ? new CharacterRunAutomaton(Regex.simpleMatchToAutomaton((String[])mappingLookup.inferenceFields().keySet().stream().map(f -> f + "*").toArray(String[]::new))) : null;
        SourceFilter filter = fetchSourceContext != null ? fetchSourceContext.filter() : null;
        ArrayList<String> lateExcludes = new ArrayList<String>();
        List<String> excludes = mappingLookup.getFullNameToFieldType().values().stream().filter(MappedFieldType::isVectorEmbedding).filter(f -> {
            if (filter != null && filter.isExplicitlyIncluded(f.name())) {
                return filter.isPathFiltered(f.name(), false);
            }
            if (fetchFieldsAut != null && fetchFieldsAut.run(f.name())) {
                lateExcludes.add(f.name());
                return false;
            }
            return inferenceFieldsAut == null || !inferenceFieldsAut.run(f.name());
        }).map(MappedFieldType::name).toList();
        SourceFilter sourceFilter2 = sourceFilter = excludes.isEmpty() ? null : new SourceFilter(new String[0], (String[])excludes.toArray(String[]::new));
        if (lateExcludes.size() > 0) {
            if (fetchSourceContext != null && fetchSourceContext.excludes() != null) {
                lateExcludes.addAll(Arrays.asList(fetchSourceContext.excludes()));
            }
            FetchSourceContext newFetchSourceContext = fetchSourceContext == null ? FetchSourceContext.of(true, false, null, (String[])lateExcludes.toArray(String[]::new)) : FetchSourceContext.of(fetchSourceContext.fetchSource(), fetchSourceContext.excludeVectors(), fetchSourceContext.excludeInferenceFields(), fetchSourceContext.includes(), (String[])lateExcludes.toArray(String[]::new));
            return Tuple.tuple((Object)newFetchSourceContext, (Object)sourceFilter);
        }
        return Tuple.tuple((Object)fetchSourceContext, (Object)sourceFilter);
    }

    private static DocumentField loadIgnoredMetadataField(VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion) throws IOException {
        SortedSetDocValues ignoredDocValues = docIdAndVersion.reader.getContext().reader().getSortedSetDocValues("_ignored");
        if (ignoredDocValues == null || !ignoredDocValues.advanceExact(docIdAndVersion.docId) || ignoredDocValues.docValueCount() <= 0) {
            return null;
        }
        ArrayList<Object> ignoredValues = new ArrayList<Object>(ignoredDocValues.docValueCount());
        for (int i = 0; i < ignoredDocValues.docValueCount(); ++i) {
            ignoredValues.add(ignoredDocValues.lookupOrd(ignoredDocValues.nextOrd()).utf8ToString());
        }
        return new DocumentField("_ignored", ignoredValues);
    }

    private static Source addInferenceMetadataFields(MapperService mapperService, LeafReaderContext readerContext, int docId, Source source) throws IOException {
        MappingLookup mappingLookup = mapperService.mappingLookup();
        InferenceMetadataFieldsMapper inferenceMetadata = (InferenceMetadataFieldsMapper)mappingLookup.getMapping().getMetadataMapperByName("_inference_fields");
        if (inferenceMetadata == null || mapperService.mappingLookup().inferenceFields().isEmpty()) {
            return source;
        }
        ValueFetcher inferenceLoader = inferenceMetadata.fieldType().valueFetcher(mappingLookup, mapperService.getBitSetProducer(), new IndexSearcher((IndexReader)readerContext.reader()));
        inferenceLoader.setNextReader(readerContext);
        List<Object> values = inferenceLoader.fetchValues(source, docId, List.of());
        if (values.size() == 1) {
            Map<String, Object> newSource = source.source();
            newSource.put("_inference_fields", values.get(0));
            return Source.fromMap(newSource, source.sourceContentType());
        }
        return source;
    }

    private static StoredFieldLoader buildStoredFieldLoader(Set<String> fields, FetchSourceContext fetchSourceContext, SourceLoader loader) {
        if (fetchSourceContext.fetchSource()) {
            fields.addAll(loader.requiredStoredFields());
        } else if (fields.isEmpty()) {
            return StoredFieldLoader.empty();
        }
        return StoredFieldLoader.create(fetchSourceContext.fetchSource(), fields);
    }
}

