/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.entitlement.bootstrap;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.core.Strings;
import org.elasticsearch.entitlement.runtime.policy.FileAccessTree;
import org.elasticsearch.entitlement.runtime.policy.PathLookup;
import org.elasticsearch.entitlement.runtime.policy.Policy;
import org.elasticsearch.entitlement.runtime.policy.Scope;
import org.elasticsearch.entitlement.runtime.policy.entitlements.FilesEntitlement;

class FilesEntitlementsValidation {
    FilesEntitlementsValidation() {
    }

    static void validate(Map<String, Policy> pluginPolicies, PathLookup pathLookup) {
        HashSet<Path> readAccessForbidden = new HashSet<Path>();
        pathLookup.getBaseDirPaths(PathLookup.BaseDir.PLUGINS).forEach(p -> readAccessForbidden.add(p.toAbsolutePath().normalize()));
        pathLookup.getBaseDirPaths(PathLookup.BaseDir.MODULES).forEach(p -> readAccessForbidden.add(p.toAbsolutePath().normalize()));
        pathLookup.getBaseDirPaths(PathLookup.BaseDir.LIB).forEach(p -> readAccessForbidden.add(p.toAbsolutePath().normalize()));
        HashSet<Path> writeAccessForbidden = new HashSet<Path>();
        pathLookup.getBaseDirPaths(PathLookup.BaseDir.CONFIG).forEach(p -> writeAccessForbidden.add(p.toAbsolutePath().normalize()));
        for (Map.Entry<String, Policy> pluginPolicy : pluginPolicies.entrySet()) {
            for (Scope scope : pluginPolicy.getValue().scopes()) {
                Optional<FilesEntitlement> filesEntitlement = scope.entitlements().stream().filter(x -> x instanceof FilesEntitlement).map(x -> (FilesEntitlement)x).findFirst();
                if (!filesEntitlement.isPresent()) continue;
                FileAccessTree fileAccessTree = FileAccessTree.withoutExclusivePaths(filesEntitlement.get(), pathLookup, List.of());
                FilesEntitlementsValidation.validateReadFilesEntitlements(pluginPolicy.getKey(), scope.moduleName(), fileAccessTree, readAccessForbidden);
                FilesEntitlementsValidation.validateWriteFilesEntitlements(pluginPolicy.getKey(), scope.moduleName(), fileAccessTree, writeAccessForbidden);
            }
        }
    }

    private static IllegalArgumentException buildValidationException(String componentName, String moduleName, Path forbiddenPath, FilesEntitlement.Mode mode) {
        return new IllegalArgumentException(Strings.format((String)"policy for module [%s] in [%s] has an invalid file entitlement. Any path under [%s] is forbidden for mode [%s].", (Object[])new Object[]{moduleName, componentName, forbiddenPath, mode}));
    }

    private static void validateReadFilesEntitlements(String componentName, String moduleName, FileAccessTree fileAccessTree, Set<Path> readForbiddenPaths) {
        for (Path forbiddenPath : readForbiddenPaths) {
            if (!fileAccessTree.canRead(forbiddenPath)) continue;
            throw FilesEntitlementsValidation.buildValidationException(componentName, moduleName, forbiddenPath, FilesEntitlement.Mode.READ);
        }
    }

    private static void validateWriteFilesEntitlements(String componentName, String moduleName, FileAccessTree fileAccessTree, Set<Path> writeForbiddenPaths) {
        for (Path forbiddenPath : writeForbiddenPaths) {
            if (!fileAccessTree.canWrite(forbiddenPath)) continue;
            throw FilesEntitlementsValidation.buildValidationException(componentName, moduleName, forbiddenPath, FilesEntitlement.Mode.READ_WRITE);
        }
    }
}

