/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.utils;

import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CollectionStringBuilder {
    private static final String DEFAULT_SEPARATOR = ",";
    private final StringBuilder sb = new StringBuilder();
    private static String separator;

    public CollectionStringBuilder() {
        separator = DEFAULT_SEPARATOR;
    }

    public CollectionStringBuilder(String separator) {
        CollectionStringBuilder.separator = separator;
    }

    public void add(String representation) {
        if (this.sb.length() > 0) {
            this.sb.append(separator);
        }
        this.sb.append(representation);
    }

    public void addValue(boolean value, String representation) {
        if (value) {
            this.add(representation);
        }
    }

    public static String join(List<String> values) {
        return StringUtils.join(values, (String)separator);
    }

    public static String join(List<String> values, String separator) {
        return StringUtils.join(values, (String)separator);
    }

    public static String join(String ... values) {
        CollectionStringBuilder sb = new CollectionStringBuilder();
        for (String value : values) {
            sb.add(value);
        }
        return sb.toString();
    }

    public String toString() {
        if (this.sb.length() == 0) {
            return null;
        }
        return this.sb.toString();
    }
}

