/*
 * Decompiled with CFR 0.152.
 */
package org.logstash;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jruby.RubyString;
import org.logstash.ConvertedMap;
import org.logstash.util.EscapeHandler;

public final class FieldReference {
    private static EscapeHandler ESCAPE_HANDLER = EscapeHandler.NONE;
    public static final int META_PARENT = 0;
    public static final int META_CHILD = 1;
    private static final int DATA_CHILD = -1;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Map<FieldReference, FieldReference> DEDUP = new HashMap<FieldReference, FieldReference>(64);
    private static final StrictTokenizer TOKENIZER = new StrictTokenizer();
    private static final Map<RubyString, FieldReference> RUBY_CACHE = new ConcurrentHashMap<RubyString, FieldReference>(64, 0.2f, 1);
    private static final Map<String, FieldReference> CACHE = new ConcurrentHashMap<String, FieldReference>(64, 0.2f, 1);
    public static final FieldReference TIMESTAMP_REFERENCE = FieldReference.from("@timestamp");
    private final String[] path;
    private final String key;
    private final int hash;
    private final int type;

    public static void setEscapeStyle(String escapeStyleSpec) {
        ESCAPE_HANDLER = switch (escapeStyleSpec) {
            case "none" -> EscapeHandler.NONE;
            case "percent" -> EscapeHandler.PERCENT;
            case "ampersand" -> EscapeHandler.AMPERSAND;
            default -> throw new IllegalArgumentException(String.format("Invalid escape style: `%s`", escapeStyleSpec));
        };
        CACHE.clear();
        RUBY_CACHE.clear();
    }

    private FieldReference(String[] path, String key, int type) {
        this.key = ConvertedMap.internStringForUseAsKey(key);
        ConvertedMap.internStringsForUseAsKeys(path);
        this.path = path;
        this.type = type;
        this.hash = FieldReference.calculateHash(this.key, this.path, this.type);
    }

    public static FieldReference from(RubyString reference) {
        FieldReference result = RUBY_CACHE.get(reference);
        if (result != null) {
            return result;
        }
        FieldReference parsed = FieldReference.from(reference.asJavaString());
        if (RUBY_CACHE.size() < 10000) {
            RUBY_CACHE.put(reference.newFrozen(), parsed);
        }
        return parsed;
    }

    public static FieldReference from(String reference) {
        FieldReference result = CACHE.get(reference);
        if (result != null) {
            return result;
        }
        return FieldReference.parseToCache(reference);
    }

    public static boolean isValid(String reference) {
        try {
            FieldReference.from(reference);
            return true;
        }
        catch (IllegalSyntaxException ise) {
            return false;
        }
    }

    public int type() {
        return this.type;
    }

    public String[] getPath() {
        return this.path;
    }

    public String getKey() {
        return this.key;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof FieldReference)) {
            return false;
        }
        FieldReference other = (FieldReference)that;
        return this.type == other.type && this.key.equals(other.key) && Arrays.equals(this.path, other.path);
    }

    public int hashCode() {
        return this.hash;
    }

    private static synchronized FieldReference deduplicate(FieldReference parsed) {
        FieldReference ret = DEDUP.get(parsed);
        if (ret == null) {
            DEDUP.put(parsed, parsed);
            ret = parsed;
        }
        return ret;
    }

    private static int calculateHash(String key, String[] path, int type) {
        int prime = 31;
        int hash = 31;
        for (String element : path) {
            hash = 31 * hash + element.hashCode();
        }
        hash = 31 * hash + key.hashCode();
        return 31 * hash + type;
    }

    private static FieldReference parseToCache(String reference) {
        FieldReference result = FieldReference.parse(reference);
        if (CACHE.size() < 10000) {
            result = FieldReference.deduplicate(result);
            CACHE.put(reference, result);
        }
        return result;
    }

    private static FieldReference parse(CharSequence reference) {
        List<String> path = TOKENIZER.tokenize(reference).stream().map(ESCAPE_HANDLER::unescape).collect(Collectors.toList());
        return FieldReference.fromTokens(path);
    }

    private static FieldReference fromTokens(List<String> path) {
        String key = path.remove(path.size() - 1);
        boolean empty = path.isEmpty();
        if (empty && key.equals("@metadata")) {
            return new FieldReference(EMPTY_STRING_ARRAY, key, 0);
        }
        if (!empty && path.get(0).equals("@metadata")) {
            return new FieldReference(path.subList(1, path.size()).toArray(EMPTY_STRING_ARRAY), key, 1);
        }
        return new FieldReference(path.toArray(EMPTY_STRING_ARRAY), key, -1);
    }

    public static class IllegalSyntaxException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        IllegalSyntaxException(String message) {
            super(message);
        }
    }

    private static class StrictTokenizer {
        private StrictTokenizer() {
        }

        public List<String> tokenize(CharSequence reference) {
            ArrayList<String> path = new ArrayList<String>();
            int length = reference.length();
            boolean potentiallyAmbiguousSyntaxDetected = false;
            boolean seenBracket = false;
            int depth = 0;
            int splitPoint = 0;
            char current = '\u0000';
            char previous = '\u0000';
            block4: for (int i = 0; i < length; ++i) {
                previous = current;
                current = reference.charAt(i);
                switch (current) {
                    case '[': {
                        seenBracket = true;
                        if (splitPoint != i) {
                            potentiallyAmbiguousSyntaxDetected = true;
                            break block4;
                        }
                        ++depth;
                        splitPoint = i + 1;
                        continue block4;
                    }
                    case ']': {
                        seenBracket = true;
                        if (depth <= 0) {
                            potentiallyAmbiguousSyntaxDetected = true;
                            break block4;
                        }
                        if (splitPoint == i && previous != ']') {
                            potentiallyAmbiguousSyntaxDetected = true;
                            break block4;
                        }
                        if (splitPoint < i) {
                            path.add(reference.subSequence(splitPoint, i).toString());
                        }
                        --depth;
                        splitPoint = i + 1;
                        continue block4;
                    }
                    default: {
                        if (!seenBracket || previous != ']') continue block4;
                        potentiallyAmbiguousSyntaxDetected = true;
                        break block4;
                    }
                }
            }
            if (!seenBracket) {
                path.add(reference.toString());
                return path;
            }
            if (depth > 0) {
                potentiallyAmbiguousSyntaxDetected = true;
            }
            if (potentiallyAmbiguousSyntaxDetected) {
                throw new IllegalSyntaxException(String.format("Invalid FieldReference: `%s`", reference.toString()));
            }
            path.trimToSize();
            return path;
        }
    }
}

