Gem::Specification.new do |s|

  s.name            = 'logstash-output-email'
  s.version         = '4.1.3'
  s.licenses        = ['Apache License (2.0)']
  s.summary         = "Sends email to a specified address when output is received"
  s.description     = "This gem is a Logstash plugin required to be installed on top of the Logstash core pipeline using $LS_HOME/bin/logstash-plugin install gemname. This gem is not a stand-alone program"
  s.authors         = ["Elastic"]
  s.email           = 'info@elastic.co'
  s.homepage        = "https://www.elastic.co/logstash"
  s.require_paths = ["lib"]

  # Files
  s.files = Dir["lib/**/*","spec/**/*","*.gemspec","*.md","CONTRIBUTORS","Gemfile","LICENSE","NOTICE.TXT", "vendor/jar-dependencies/**/*.jar", "vendor/jar-dependencies/**/*.rb", "VERSION", "docs/**/*"]

  # Tests
  s.test_files = s.files.grep(%r{^(test|spec|features)/})

  # Special flag to let us know this is actually a logstash plugin
  s.metadata = { "logstash_plugin" => "true", "logstash_group" => "output" }

  # Gem dependencies
  s.add_runtime_dependency "logstash-core-plugin-api", ">= 1.60", "<= 2.99"

  s.add_runtime_dependency 'mail', '~> 2.8'


  s.add_runtime_dependency 'mustache', '>= 0.99.8'

  s.add_development_dependency 'logstash-devutils'
  s.add_development_dependency 'rumbster'
  s.add_development_dependency 'logstash-input-generator'
  s.add_development_dependency 'gserver'

end

