/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import java.util.Arrays;
import java.util.List;
import org.logstash.settings.BaseSetting;
import org.logstash.settings.DeprecatedAlias;
import org.logstash.settings.Setting;
import org.logstash.settings.SettingDelegator;

public class SettingWithDeprecatedAlias<T>
extends SettingDelegator<T> {
    private DeprecatedAlias<T> deprecatedAlias;

    static <T> List<Setting<T>> wrap(BaseSetting<T> canonicalSetting, String deprecatedAliasName, String obsoletedVersion) {
        SettingWithDeprecatedAlias<T> settingProxy = new SettingWithDeprecatedAlias<T>(canonicalSetting, deprecatedAliasName, obsoletedVersion);
        return Arrays.asList(settingProxy, settingProxy.deprecatedAlias);
    }

    protected SettingWithDeprecatedAlias(BaseSetting<T> canonicalSetting, String deprecatedAliasName, String obsoletedVersion) {
        super(canonicalSetting);
        this.deprecatedAlias = new DeprecatedAlias(this, deprecatedAliasName, obsoletedVersion);
    }

    BaseSetting<T> getCanonicalSetting() {
        return this.getDelegate();
    }

    public DeprecatedAlias<T> getDeprecatedAlias() {
        return this.deprecatedAlias;
    }

    @Override
    public void setSafely(T value) {
        this.getCanonicalSetting().setSafely(value);
    }

    @Override
    public T value() {
        if (this.getCanonicalSetting().isSet()) {
            return super.value();
        }
        if (this.deprecatedAlias.isSet()) {
            return this.deprecatedAlias.getDelegate().value();
        }
        return (T)this.getDefault();
    }

    @Override
    public boolean isSet() {
        return this.getCanonicalSetting().isSet() || this.deprecatedAlias.isSet();
    }

    @Override
    public void format(List<String> output) {
        if (!this.deprecatedAlias.isSet() || this.getCanonicalSetting().isSet()) {
            super.format(output);
            return;
        }
        output.add(String.format("*%s: %s (via deprecated `%s`; default: %s)", this.getName(), this.value(), this.deprecatedAlias.getName(), this.getDefault()));
    }

    @Override
    public void validateValue() {
        if (this.deprecatedAlias.isSet() && this.getCanonicalSetting().isSet()) {
            throw new IllegalStateException(String.format("Both `%s` and its deprecated alias `%s` have been set. Please only set `%s`", this.getCanonicalSetting().getName(), this.deprecatedAlias.getName(), this.getCanonicalSetting().getName()));
        }
        super.validateValue();
    }
}

