/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.settings;

import java.util.function.Predicate;
import org.logstash.settings.BaseSetting;

public abstract class Coercible<T>
extends BaseSetting<T> {
    public Coercible(String name, T defaultValue, boolean strict, Predicate<T> validator) {
        super(name, strict, validator);
        if (strict) {
            T coercedDefault = this.coerce(defaultValue);
            this.validate(coercedDefault);
            this.defaultValue = coercedDefault;
        } else {
            this.defaultValue = defaultValue;
        }
    }

    @Override
    public void set(Object value) {
        T coercedValue = this.coerce(value);
        this.validate(coercedValue);
        super.setSafely(coercedValue);
    }

    @Override
    public void setSafely(T value) {
        this.set(value);
    }

    public abstract T coerce(Object var1);
}

