/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.secret;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;
import org.logstash.plugins.ConfigVariableExpander;

public class SecretIdentifier {
    private static final Pattern colonPattern = Pattern.compile(":");
    private static final String VERSION = "v1";
    private static final Pattern urnPattern = Pattern.compile("urn:logstash:secret:v1:.*$");
    private final String key;
    private static final Logger logger = LogManager.getLogger(SecretIdentifier.class);

    public SecretIdentifier(String key) {
        this.key = SecretIdentifier.validateWithTransform(key, "key");
    }

    public static SecretIdentifier fromExternalForm(String urn) {
        if (urn == null || !urnPattern.matcher(urn).matches()) {
            throw new IllegalArgumentException("Invalid external form " + urn);
        }
        String[] parts = colonPattern.split(urn, 5);
        return new SecretIdentifier(SecretIdentifier.validateWithTransform(parts[4], "key"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretIdentifier that = (SecretIdentifier)o;
        return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (VERSION != null ? VERSION.hashCode() : 0);
        return result;
    }

    public String toExternalForm() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("urn").append(":");
        sb.append("logstash").append(":");
        sb.append("secret").append(":");
        sb.append(VERSION).append(":");
        sb.append(this.key);
        return sb.toString();
    }

    public String toString() {
        return this.toExternalForm();
    }

    private static String validateWithTransform(String key, String partName) {
        if (key == null || key.isEmpty() || Strings.isBlank((String)key)) {
            throw new IllegalArgumentException(String.format("%s may not be null or empty", partName));
        }
        if (!ConfigVariableExpander.KEY_PATTERN.matcher(key).matches()) {
            logger.warn(String.format("Invalid secret key name `%s` provided. %s", key, "Key names are limited to ASCII letters (`a`-`z`, `A`-`Z`), numbers (`0`-`9`), underscores (`_`), and dots (`.`); they must be at least one character long and cannot begin with a number"));
        }
        return key.toLowerCase(Locale.US);
    }
}

