/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue;

import co.elastic.logstash.api.Metric;
import co.elastic.logstash.api.NamespacedMetric;
import com.github.luben.zstd.Zstd;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.ackedqueue.AtomicIORatioMetric;
import org.logstash.ackedqueue.CalculatedRelativeSpendMetric;
import org.logstash.ackedqueue.CompressionCodec;
import org.logstash.ackedqueue.IORatioMetric;
import org.logstash.ackedqueue.RelativeSpendMetric;

abstract class AbstractZstdAwareCompressionCodec
implements CompressionCodec {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final IORatioMetric decodeRatioMetric;
    private final RelativeSpendMetric decodeTimerMetric;
    private static final byte[] ZSTD_FRAME_MAGIC = new byte[]{40, -75, 47, -3};

    public AbstractZstdAwareCompressionCodec(Metric queueMetric) {
        NamespacedMetric decodeNamespace = queueMetric.namespace("compression", "decode");
        this.decodeRatioMetric = decodeNamespace.namespace("ratio").register("lifetime", AtomicIORatioMetric.FACTORY);
        this.decodeTimerMetric = decodeNamespace.namespace("spend").register("lifetime", CalculatedRelativeSpendMetric.FACTORY);
    }

    @Override
    public byte[] decode(byte[] data) {
        if (!AbstractZstdAwareCompressionCodec.isZstd(data)) {
            this.decodeRatioMetric.incrementBy(data.length, data.length);
            return data;
        }
        try {
            byte[] decoded = this.decodeTimerMetric.time(() -> Zstd.decompress((byte[])data));
            this.decodeRatioMetric.incrementBy(data.length, decoded.length);
            this.logger.trace("decoded {} -> {}", (Object)data.length, (Object)decoded.length);
            return decoded;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while decoding", e);
        }
    }

    static boolean isZstd(byte[] data) {
        if (data.length < 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (data[i] == ZSTD_FRAME_MAGIC[i]) continue;
            return false;
        }
        return true;
    }
}

