/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.inputs.http.util;

import java.util.Map;
import org.logstash.plugins.inputs.http.IMessageHandler;
import org.logstash.plugins.inputs.http.util.ExecutionObserver;

public class ExecutionObservingMessageHandler
implements IMessageHandler {
    private final ExecutionObserver executionObserver;
    private final IMessageHandler delegate;

    public ExecutionObservingMessageHandler(ExecutionObserver executionObserver, IMessageHandler delegate) {
        this.executionObserver = executionObserver;
        this.delegate = delegate;
    }

    @Override
    public boolean onNewMessage(String remoteAddress, Map<String, String> headers, String body) {
        return this.executionObserver.observeExecution(() -> this.delegate.onNewMessage(remoteAddress, headers, body));
    }

    @Override
    public boolean validatesToken(String token) {
        return this.delegate.validatesToken(token);
    }

    @Override
    public boolean requiresToken() {
        return this.delegate.requiresToken();
    }

    @Override
    public IMessageHandler copy() {
        return new ExecutionObservingMessageHandler(this.executionObserver, this.delegate.copy());
    }

    @Override
    public Map<String, String> responseHeaders() {
        return this.delegate.responseHeaders();
    }
}

