/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.inputs.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadPoolExecutor;
import org.logstash.plugins.inputs.http.IMessageHandler;
import org.logstash.plugins.inputs.http.MessageProcessor;

public class HttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final IMessageHandler messageHandler;
    private final ThreadPoolExecutor executorGroup;
    private final HttpResponseStatus responseStatus;

    public HttpServerHandler(IMessageHandler messageHandler, ThreadPoolExecutor executorGroup, HttpResponseStatus responseStatus) {
        this.messageHandler = messageHandler;
        this.executorGroup = executorGroup;
        this.responseStatus = responseStatus;
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
        String remoteAddress = ((InetSocketAddress)ctx.channel().remoteAddress()).getAddress().getHostAddress();
        msg.retain();
        MessageProcessor messageProcessor = new MessageProcessor(ctx, msg, remoteAddress, this.messageHandler, this.responseStatus);
        this.executorGroup.execute(messageProcessor);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ByteBuf content = Unpooled.copiedBuffer((byte[])cause.getMessage().getBytes());
        HttpResponseStatus responseStatus = cause instanceof DecompressionException ? HttpResponseStatus.BAD_REQUEST : HttpResponseStatus.INTERNAL_SERVER_ERROR;
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, content);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
        ctx.writeAndFlush((Object)response);
    }
}

