/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.fluent;

import java.security.cert.X509Certificate;
import org.snmp4j.CommunityTarget;
import org.snmp4j.DirectUserTarget;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.Target;
import org.snmp4j.fluent.PduBuilder;
import org.snmp4j.fluent.SnmpBuilder;
import org.snmp4j.security.AuthHMAC128SHA224;
import org.snmp4j.security.AuthHMAC192SHA256;
import org.snmp4j.security.AuthHMAC256SHA384;
import org.snmp4j.security.AuthHMAC384SHA512;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.nonstandard.PrivAES192With3DESKeyExtension;
import org.snmp4j.security.nonstandard.PrivAES256With3DESKeyExtension;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;
import org.snmp4j.transport.tls.TlsX509CertifiedTarget;

public class TargetBuilder<A extends Address> {
    protected final SnmpBuilder snmpBuilder;
    protected A address;
    protected OctetString securityName;
    protected SnmpVersion snmpVersion = SnmpVersion.v3;
    protected Target<A> target;
    protected long timeoutMillis = SNMP4JSettings.getDefaultTimeoutMillis();
    protected int retries = SNMP4JSettings.getDefaultRetries();
    protected int maxSizeRequestPDU = SNMP4JSettings.getMaxSizeRequestPDU();

    public TargetBuilder(SnmpBuilder snmpBuilder) {
        this.snmpBuilder = snmpBuilder;
    }

    protected TargetBuilder(SnmpBuilder snmpBuilder, A address) {
        this.snmpBuilder = snmpBuilder;
        this.address = address;
    }

    public static <A extends Address> TargetBuilder<A> forAddress(SnmpBuilder snmpBuilder, A address) {
        return new TargetBuilder<A>(snmpBuilder, address);
    }

    public TargetBuilder<A> address(A address) {
        this.address = address;
        return this;
    }

    public TargetBuilder<A> v1() {
        this.snmpVersion = SnmpVersion.v1;
        return this;
    }

    public TargetBuilder<A> v2c() {
        this.snmpVersion = SnmpVersion.v2c;
        return this;
    }

    public TargetBuilder<A> v3() {
        this.snmpVersion = SnmpVersion.v3;
        return this;
    }

    public TargetBuilder<A> timeout(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
        return this;
    }

    public TargetBuilder<A> retries(int retries) {
        this.retries = retries;
        return this;
    }

    public void maxSizeRequestPDU(int maxSizeRequestPDU) {
        this.maxSizeRequestPDU = maxSizeRequestPDU;
    }

    public TargetBuilder<A> community(OctetString snmpV1V2Community) {
        this.securityName = snmpV1V2Community;
        if (this.snmpVersion == SnmpVersion.v3) {
            this.snmpVersion = SnmpVersion.v2c;
        }
        this.target = new CommunityTarget<A>(this.address, this.securityName);
        return this;
    }

    public DirectUserBuilder user(String securityName) {
        return this.user(securityName, null);
    }

    public DirectUserBuilder user(String securityName, byte[] authoritativeEngineID) {
        return this.user(new OctetString(securityName), authoritativeEngineID);
    }

    public DirectUserBuilder user(OctetString securityName) {
        return this.user(securityName, null);
    }

    public DirectUserBuilder user(OctetString securityName, byte[] authoritativeEngineID) {
        this.snmpVersion = SnmpVersion.v3;
        return new DirectUserBuilder(securityName, authoritativeEngineID);
    }

    public TlsTargetBuilder tls(String identity) {
        return this.tls(new OctetString(identity));
    }

    public TlsTargetBuilder tls(OctetString identity) {
        return new TlsTargetBuilder(identity);
    }

    public TlsTargetBuilder dtls(String identity) {
        return this.dtls(new OctetString(identity));
    }

    public TlsTargetBuilder dtls(OctetString identity) {
        return new TlsTargetBuilder(identity);
    }

    public Target<A> build() {
        this.target.setTimeout(this.timeoutMillis);
        this.target.setRetries(this.retries);
        this.target.setVersion(this.snmpVersion.version);
        return this.target;
    }

    public PduBuilder pdu() {
        return new PduBuilder(this);
    }

    public static enum SnmpVersion {
        v1(0),
        v2c(1),
        v3(3);

        private final int version;

        private SnmpVersion(int version) {
            this.version = version;
        }

        public int getVersion() {
            return this.version;
        }
    }

    public class DirectUserBuilder {
        private byte[] authoritativeEngineID;
        private final OctetString securityName;
        private AuthProtocol authenticationProtocol;
        private PrivProtocol privacyProtocol;
        private OctetString authPassword;
        private OctetString privPassword;

        protected DirectUserBuilder(OctetString securityName) {
            this.securityName = securityName;
        }

        protected DirectUserBuilder(OctetString securityName, byte[] authoritativeEngineID) {
            this.authoritativeEngineID = authoritativeEngineID;
            this.securityName = securityName;
        }

        public DirectUserBuilder auth(AuthProtocol authenticationProtocol) {
            this.authenticationProtocol = authenticationProtocol;
            return this;
        }

        public DirectUserBuilder priv(PrivProtocol privacyProtocol) {
            this.privacyProtocol = privacyProtocol;
            return this;
        }

        public DirectUserBuilder authPassphrase(String authPassword) {
            return this.authPassphrase(OctetString.fromString(authPassword));
        }

        public DirectUserBuilder authPassphrase(OctetString authPassword) {
            this.authPassword = authPassword;
            return this;
        }

        public DirectUserBuilder privPassphrase(String privPassword) {
            return this.privPassphrase(OctetString.fromString(privPassword));
        }

        public DirectUserBuilder privPassphrase(OctetString privPassword) {
            this.privPassword = privPassword;
            return this;
        }

        public TargetBuilder<A> done() {
            if (this.authoritativeEngineID == null) {
                this.authoritativeEngineID = TargetBuilder.this.snmpBuilder.snmp.discoverAuthoritativeEngineID(TargetBuilder.this.address, TargetBuilder.this.timeoutMillis);
            }
            byte[] authKey = null;
            byte[] privKey = null;
            SecurityProtocols securityProtocols = TargetBuilder.this.snmpBuilder.securityProtocols;
            if (this.authenticationProtocol != null && this.authPassword != null) {
                if (this.authoritativeEngineID == null) {
                    throw new IllegalArgumentException("Authoritative Engine ID not provided");
                }
                authKey = securityProtocols.passwordToKey(this.authenticationProtocol.getProtocolID(), this.authPassword, this.authoritativeEngineID);
                if (this.privacyProtocol != null && this.privPassword != null) {
                    privKey = securityProtocols.passwordToKey(this.privacyProtocol.getProtocolID(), this.authenticationProtocol.getProtocolID(), this.privPassword, this.authoritativeEngineID);
                }
            }
            TargetBuilder.this.target = this.authenticationProtocol == null || authKey == null ? new DirectUserTarget(TargetBuilder.this.address, this.securityName, this.authoritativeEngineID, null, null, null, null) : (this.privacyProtocol == null || privKey == null ? new DirectUserTarget(TargetBuilder.this.address, this.securityName, this.authoritativeEngineID, securityProtocols.getAuthenticationProtocol(this.authenticationProtocol.getProtocolID()), new OctetString(authKey), null, null) : new DirectUserTarget(TargetBuilder.this.address, this.securityName, this.authoritativeEngineID, securityProtocols.getAuthenticationProtocol(this.authenticationProtocol.getProtocolID()), new OctetString(authKey), securityProtocols.getPrivacyProtocol(this.privacyProtocol.getProtocolID()), new OctetString(privKey)));
            return TargetBuilder.this;
        }
    }

    public class TlsTargetBuilder {
        private final OctetString identity;
        private OctetString serverFingerprint;
        private OctetString clientFingerprint;
        private TlsTmSecurityCallback<X509Certificate> tlsTmSecurityCallback;

        protected TlsTargetBuilder(OctetString identity) {
            this.identity = identity;
        }

        public TlsTargetBuilder serverFingerprint(OctetString fingerprint) {
            this.serverFingerprint = fingerprint;
            return this;
        }

        public TlsTargetBuilder clientFingerprint(OctetString fingerprint) {
            this.clientFingerprint = fingerprint;
            return this;
        }

        public TlsTargetBuilder securityCallback(TlsTmSecurityCallback<X509Certificate> tlsTmSecurityCallback) {
            this.tlsTmSecurityCallback = tlsTmSecurityCallback;
            return this;
        }

        public TargetBuilder<A> done() {
            TargetBuilder.this.target = new TlsX509CertifiedTarget(TargetBuilder.this.address, this.identity, this.serverFingerprint, this.clientFingerprint, this.tlsTmSecurityCallback);
            return TargetBuilder.this;
        }
    }

    public static enum PrivProtocol {
        des("DES", PrivDES.ID),
        _3des("3DES", Priv3DES.ID),
        aes128("AES-128", PrivAES128.ID),
        aes192("AES-192", PrivAES192.ID),
        aes256("AES-256", PrivAES256.ID),
        aes192with3DESKeyExtension("AES-192-3DESkeyext", PrivAES192With3DESKeyExtension.ID),
        aes256with3DESKeyExtension("AES-256-3DESkeyext", PrivAES256With3DESKeyExtension.ID);

        private final OID protocolID;
        private final String name;

        private PrivProtocol(String name, OID protocolID) {
            this.name = name;
            this.protocolID = protocolID;
        }

        public OID getProtocolID() {
            return this.protocolID;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum AuthProtocol {
        md5("MD5", AuthMD5.ID),
        sha1("SHA-1", AuthSHA.ID),
        hmac128sha224("SHA-224", AuthHMAC128SHA224.ID),
        hmac192sha256("SHA-256", AuthHMAC192SHA256.ID),
        hmac256sha384("SHA-384", AuthHMAC256SHA384.ID),
        hmac384sha512("SHA-512", AuthHMAC384SHA512.ID);

        private final OID protocolID;
        private final String name;

        private AuthProtocol(String name, OID protocolID) {
            this.name = name;
            this.protocolID = protocolID;
        }

        public OID getProtocolID() {
            return this.protocolID;
        }

        public String getName() {
            return this.name;
        }
    }
}

