/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;

public class SequenceWrapper
extends SequenceReceiver {
    public static final String RESULT_NS = QueryResult.RESULT_NS;
    private Receiver out;
    private int depth = 0;
    private FingerprintedQName resultSequence;
    private FingerprintedQName resultDocument;
    private FingerprintedQName resultElement;
    private FingerprintedQName resultAttribute;
    private FingerprintedQName resultText;
    private FingerprintedQName resultComment;
    private FingerprintedQName resultPI;
    private FingerprintedQName resultNamespace;
    private FingerprintedQName resultAtomicValue;
    private FingerprintedQName xsiType;

    public SequenceWrapper(Receiver destination) {
        super(destination.getPipelineConfiguration());
        this.out = destination;
    }

    public Receiver getDestination() {
        return this.out;
    }

    public void open() throws XPathException {
        this.resultSequence = new FingerprintedQName("result", RESULT_NS, "sequence");
        this.resultDocument = new FingerprintedQName("result", RESULT_NS, "document");
        this.resultElement = new FingerprintedQName("result", RESULT_NS, "element");
        this.resultAttribute = new FingerprintedQName("result", RESULT_NS, "attribute");
        this.resultText = new FingerprintedQName("result", RESULT_NS, "text");
        this.resultComment = new FingerprintedQName("result", RESULT_NS, "comment");
        this.resultPI = new FingerprintedQName("result", RESULT_NS, "processing-instruction");
        this.resultNamespace = new FingerprintedQName("result", RESULT_NS, "namespace");
        this.resultAtomicValue = new FingerprintedQName("result", RESULT_NS, "atomic-value");
        this.xsiType = new FingerprintedQName("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type");
        this.out.open();
        this.out.startDocument(0);
        this.out.startElement(this.resultSequence, Untyped.getInstance(), 0, 0);
        this.out.namespace(new NamespaceBinding("result", RESULT_NS), 0);
        this.out.namespace(new NamespaceBinding("xs", "http://www.w3.org/2001/XMLSchema"), 0);
        this.out.namespace(new NamespaceBinding("xsi", "http://www.w3.org/2001/XMLSchema-instance"), 0);
        this.out.startContent();
    }

    public void startDocument(int properties) throws XPathException {
        this.out.startElement(this.resultDocument, Untyped.getInstance(), 0, 0);
        this.out.startContent();
        ++this.depth;
    }

    public void endDocument() throws XPathException {
        this.out.endElement();
        --this.depth;
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, int locationId, int properties) throws XPathException {
        if (this.depth++ == 0) {
            this.out.startElement(this.resultElement, Untyped.getInstance(), 0, 0);
            this.out.startContent();
        }
        this.out.startElement(nameCode, typeCode, locationId, properties);
    }

    public void endElement() throws XPathException {
        this.out.endElement();
        if (--this.depth == 0) {
            this.out.endElement();
        }
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultAttribute, Untyped.getInstance(), 0, 0);
            if (!attName.hasURI("")) {
                this.out.namespace(attName.getNamespaceBinding(), 0);
            }
            this.out.attribute(attName, typeCode, value, locationId, properties);
            this.out.startContent();
            this.out.endElement();
        } else {
            this.out.attribute(attName, typeCode, value, locationId, properties);
        }
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultNamespace, Untyped.getInstance(), 0, 0);
            this.out.namespace(namespaceBinding, properties);
            this.out.startContent();
            this.out.endElement();
        } else {
            this.out.namespace(namespaceBinding, properties);
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultText, Untyped.getInstance(), 0, 0);
            this.out.startContent();
            this.out.characters(chars, locationId, properties);
            this.out.endElement();
        } else {
            this.out.characters(chars, locationId, properties);
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultComment, Untyped.getInstance(), 0, 0);
            this.out.startContent();
            this.out.comment(chars, locationId, properties);
            this.out.endElement();
        } else {
            this.out.comment(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultPI, Untyped.getInstance(), 0, 0);
            this.out.startContent();
            this.out.processingInstruction(target, data, locationId, properties);
            this.out.endElement();
        } else {
            this.out.processingInstruction(target, data, locationId, properties);
        }
    }

    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        if (item instanceof FunctionItem) {
            throw new XPathException("Wrapped output: cannot display a function item");
        }
        if (item instanceof ObjectValue) {
            throw new XPathException("Wrapped output: cannot display an external Java object");
        }
        if (item instanceof AtomicValue) {
            NamePool pool = this.getNamePool();
            this.out.startElement(this.resultAtomicValue, Untyped.getInstance(), 0, 0);
            AtomicType type = ((AtomicValue)item).getItemType();
            int nameCode = type.getNameCode();
            String prefix = pool.getPrefix(nameCode);
            String localName = pool.getLocalName(nameCode);
            String uri = pool.getURI(nameCode);
            if (prefix.length() == 0 && (prefix = pool.suggestPrefixForURI(uri)) == null) {
                prefix = "p" + uri.hashCode();
            }
            String displayName = prefix + ':' + localName;
            this.out.namespace(new NamespaceBinding(prefix, uri), 0);
            this.out.attribute(this.xsiType, BuiltInAtomicType.UNTYPED_ATOMIC, displayName, 0, 0);
            this.out.startContent();
            this.out.characters(item.getStringValue(), 0, 0);
            this.out.endElement();
        } else {
            ((NodeInfo)item).copy(this, 6, locationId);
        }
    }

    public void startContent() throws XPathException {
        this.out.startContent();
    }

    public void close() throws XPathException {
        this.out.endElement();
        this.out.endDocument();
        this.out.close();
    }

    public boolean usesTypeAnnotations() {
        return true;
    }
}

