/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client;

import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import java.util.Collections;
import java.util.List;

public class SchemaMetadata {
    private String subject;
    private int id;
    private int version;
    private String schemaType;
    private String schema;
    private List<SchemaReference> references;
    private Metadata metadata = null;
    private RuleSet ruleSet = null;

    public SchemaMetadata(int id, int version, String schema) {
        this(id, version, "AVRO", Collections.emptyList(), schema);
    }

    public SchemaMetadata(int id, int version, String schemaType, List<SchemaReference> references, String schema) {
        this.id = id;
        this.version = version;
        this.schemaType = schemaType;
        this.schema = schema;
        this.references = references;
    }

    public SchemaMetadata(Schema schema) {
        this.subject = schema.getSubject();
        this.id = schema.getId();
        this.version = schema.getVersion();
        this.schemaType = schema.getSchemaType();
        this.schema = schema.getSchema();
        this.references = schema.getReferences();
        this.metadata = schema.getMetadata();
        this.ruleSet = schema.getRuleSet();
    }

    public String getSubject() {
        return this.subject;
    }

    public int getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public String getSchema() {
        return this.schema;
    }

    public List<SchemaReference> getReferences() {
        return this.references;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }
}

