/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.EventHubException;
import java.util.Locale;

public final class ReceiverOptions {
    private boolean receiverRuntimeMetricEnabled;
    private String identifier;
    private int prefetchCount = 500;

    private static void validateReceiverIdentifier(String receiverName) {
        if (receiverName != null && receiverName.length() > 64) {
            throw new IllegalArgumentException("receiverIdentifier length cannot exceed 64");
        }
    }

    public boolean getReceiverRuntimeMetricEnabled() {
        return this.receiverRuntimeMetricEnabled;
    }

    public void setReceiverRuntimeMetricEnabled(boolean value) {
        this.receiverRuntimeMetricEnabled = value;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String value) {
        ReceiverOptions.validateReceiverIdentifier(value);
        this.identifier = value;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public void setPrefetchCount(int prefetchCount) throws EventHubException {
        if (prefetchCount < 1) {
            throw new IllegalArgumentException(String.format(Locale.US, "PrefetchCount has to be above %s", 1));
        }
        if (prefetchCount > 8000) {
            throw new IllegalArgumentException(String.format(Locale.US, "PrefetchCount has to be below %s", 8000));
        }
        this.prefetchCount = prefetchCount;
    }
}

