/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.io.CloneableStream;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.BufferedByteHolderInputStream;
import org.apache.derby.impl.store.raw.data.ByteHolder;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

public class OverflowInputStream
extends BufferedByteHolderInputStream
implements Resetable,
CloneableStream {
    protected BaseContainerHandle owner;
    protected long overflowPage;
    protected int overflowId;
    protected long firstOverflowPage;
    protected int firstOverflowId;
    protected RecordHandle recordToLock;
    private boolean initialized = false;

    public OverflowInputStream(ByteHolder bh, BaseContainerHandle owner, long overflowPage, int overflowId, RecordHandle recordToLock) {
        super(bh);
        this.owner = owner;
        this.overflowPage = overflowPage;
        this.overflowId = overflowId;
        this.firstOverflowPage = overflowPage;
        this.firstOverflowId = overflowId;
        this.recordToLock = recordToLock;
    }

    @Override
    public void fillByteHolder() throws IOException {
        if (this.bh.available() == 0 && this.overflowPage != -1L) {
            this.bh.clear();
            try {
                BasePage columnOverflowPage = (BasePage)this.owner.getPage(this.overflowPage);
                if (columnOverflowPage == null) {
                    throw new EOFException(MessageService.getTextMessage((String)"D015", (Object[])new Object[0]));
                }
                columnOverflowPage.restorePortionLongColumn(this);
                columnOverflowPage.unlatch();
                columnOverflowPage = null;
            }
            catch (StandardException se) {
                throw new IOException(se);
            }
            this.bh.startReading();
        }
    }

    public void setOverflowPage(long overflowPage) {
        this.overflowPage = overflowPage;
    }

    public void setOverflowId(int overflowId) {
        this.overflowId = overflowId;
    }

    public long getOverflowPage() {
        return this.overflowPage;
    }

    public int getOverflowId() {
        return this.overflowId;
    }

    @Override
    public void initStream() throws StandardException {
        if (this.initialized) {
            return;
        }
        if (this.owner.getTransaction() == null) {
            throw StandardException.newException((String)"40XD0", (Object[])new Object[0]);
        }
        LockingPolicy lp = this.owner.getTransaction().newLockingPolicy(1, 2, true);
        this.owner = (BaseContainerHandle)this.owner.getTransaction().openContainer(this.owner.getId(), lp, this.owner.getMode());
        this.owner.getLockingPolicy().lockRecordForRead(this.owner.getTransaction(), this.owner, this.recordToLock, true, false);
        this.initialized = true;
    }

    @Override
    public void resetStream() throws IOException, StandardException {
        this.owner.checkOpen();
        this.overflowPage = this.firstOverflowPage;
        this.overflowId = this.firstOverflowId;
        this.bh.clear();
        this.bh.startReading();
    }

    @Override
    public void closeStream() {
        this.owner.close();
        this.initialized = false;
    }

    @Override
    public InputStream cloneStream() {
        OverflowInputStream ret_stream = new OverflowInputStream(this.bh.cloneEmpty(), this.owner, this.firstOverflowPage, this.firstOverflowId, this.recordToLock);
        return ret_stream;
    }
}

