/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import java.util.Vector;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortInfo;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.impl.store.access.sort.MergeSortInfo;
import org.apache.derby.impl.store.access.sort.SortBuffer;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

final class MergeInserter
implements SortController {
    private MergeSort sort;
    private TransactionManager tran;
    private Vector<Long> mergeRuns;
    private SortBuffer sortBuffer;
    private long beginMemoryUsage;
    private boolean avoidMergeRun;
    private int runSize;
    private int totalRunSize;
    String stat_sortType;
    int stat_numRowsInput;
    int stat_numRowsOutput;
    int stat_numMergeRuns;
    Vector<Integer> stat_mergeRunsSize;

    MergeInserter() {
    }

    @Override
    public void insert(DataValueDescriptor[] row) throws StandardException {
        SanityManager.ASSERT((this.sort != null ? 1 : 0) != 0);
        this.sort.checkColumnTypes(row);
        int insertResult = this.sortBuffer.insert(row);
        ++this.stat_numRowsInput;
        if (insertResult != 1) {
            ++this.stat_numRowsOutput;
        }
        if (insertResult == 2) {
            if (this.avoidMergeRun) {
                Runtime jvm = Runtime.getRuntime();
                if (SanityManager.DEBUG_ON((String)"SortTuning")) {
                    jvm.gc();
                    jvm.gc();
                    jvm.gc();
                }
                long currentFreeMemory = jvm.freeMemory();
                long currentTotalMemory = jvm.totalMemory();
                long currentMemoryUsage = currentTotalMemory - currentFreeMemory;
                long estimatedMemoryUsed = currentMemoryUsage - this.beginMemoryUsage;
                if (SanityManager.DEBUG_ON((String)"SortTuning")) {
                    SanityManager.DEBUG((String)"SortTuning", (String)("Growing sortBuffer dynamically, current sortBuffer capacity= " + this.sortBuffer.capacity() + " estimatedMemoryUsed = " + estimatedMemoryUsed + " currentTotalMemory = " + currentTotalMemory + " currentFreeMemory = " + currentFreeMemory + " numcolumn = " + row.length + " real per row memory = " + estimatedMemoryUsed / (long)this.sortBuffer.capacity()));
                }
                if (estimatedMemoryUsed < 0L) {
                    this.beginMemoryUsage = currentMemoryUsage;
                }
                if (estimatedMemoryUsed < 0L || 2L * estimatedMemoryUsed < (estimatedMemoryUsed + currentFreeMemory) / 2L || 2L * estimatedMemoryUsed < 0x100000L && currentTotalMemory < 0x500000L) {
                    this.sortBuffer.grow(100);
                    if (this.sortBuffer.insert(row) != 2) {
                        return;
                    }
                }
                this.avoidMergeRun = false;
            }
            this.stat_sortType = "external";
            long conglomid = this.sort.createMergeRun(this.tran, this.sortBuffer);
            if (this.mergeRuns == null) {
                this.mergeRuns = new Vector();
            }
            this.mergeRuns.addElement(conglomid);
            ++this.stat_numMergeRuns;
            this.runSize = this.stat_numRowsInput - this.totalRunSize - 1;
            this.totalRunSize += this.runSize;
            this.stat_mergeRunsSize.addElement(this.runSize);
            this.sortBuffer.insert(row);
        }
    }

    @Override
    public void completedInserts() {
        if (this.sort != null) {
            this.sort.doneInserting(this, this.sortBuffer, this.mergeRuns);
        }
        if (this.stat_sortType == "external") {
            ++this.stat_numMergeRuns;
            this.stat_mergeRunsSize.addElement(this.stat_numRowsInput - this.totalRunSize);
        }
        this.tran.closeMe(this);
        this.sort = null;
        this.tran = null;
        this.mergeRuns = null;
        this.sortBuffer = null;
    }

    @Override
    public SortInfo getSortInfo() throws StandardException {
        return new MergeSortInfo(this);
    }

    boolean initialize(MergeSort sort, TransactionManager tran) {
        Runtime jvm = Runtime.getRuntime();
        if (SanityManager.DEBUG_ON((String)"SortTuning")) {
            jvm.gc();
            jvm.gc();
            jvm.gc();
        }
        this.beginMemoryUsage = jvm.totalMemory() - jvm.freeMemory();
        this.avoidMergeRun = true;
        this.stat_sortType = "internal";
        this.stat_numMergeRuns = 0;
        this.stat_numRowsInput = 0;
        this.stat_numRowsOutput = 0;
        this.stat_mergeRunsSize = new Vector();
        this.runSize = 0;
        this.totalRunSize = 0;
        if (SanityManager.DEBUG_ON((String)"testSort")) {
            this.avoidMergeRun = false;
        }
        this.sort = sort;
        this.tran = tran;
        this.sortBuffer = new SortBuffer(sort);
        return this.sortBuffer.init();
    }
}

