/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class BranchRow {
    public static final long DUMMY_PAGE_NUMBER = -1L;
    private DataValueDescriptor[] branchrow = null;

    private BranchRow() {
    }

    private BranchRow(Transaction rawtran, BTree btree) throws StandardException {
        SQLLongint child_page = new SQLLongint(-1L);
        this.branchrow = btree.createBranchTemplate(rawtran, child_page);
        SanityManager.ASSERT((child_page == (SQLLongint)this.branchrow[this.branchrow.length - 1] ? 1 : 0) != 0);
    }

    private SQLLongint getChildPage() {
        SanityManager.ASSERT((this.branchrow != null ? 1 : 0) != 0);
        SanityManager.ASSERT((boolean)(this.branchrow[this.branchrow.length - 1] instanceof SQLLongint));
        return (SQLLongint)this.branchrow[this.branchrow.length - 1];
    }

    public static BranchRow createEmptyTemplate(Transaction rawtran, BTree btree) throws StandardException {
        return new BranchRow(rawtran, btree);
    }

    public BranchRow createBranchRowFromOldBranchRow(long childpageno) {
        BranchRow newbranch = new BranchRow();
        newbranch.branchrow = new DataValueDescriptor[this.branchrow.length];
        System.arraycopy(this.branchrow, 0, newbranch.branchrow, 0, newbranch.branchrow.length - 1);
        newbranch.branchrow[newbranch.branchrow.length - 1] = new SQLLongint(childpageno);
        return newbranch;
    }

    public static BranchRow createBranchRowFromOldLeafRow(DataValueDescriptor[] leafrow, long childpageno) {
        BranchRow newbranch = new BranchRow();
        newbranch.branchrow = new DataValueDescriptor[leafrow.length + 1];
        System.arraycopy(leafrow, 0, newbranch.branchrow, 0, leafrow.length);
        newbranch.branchrow[newbranch.branchrow.length - 1] = new SQLLongint(childpageno);
        return newbranch;
    }

    protected DataValueDescriptor[] getRow() {
        return this.branchrow;
    }

    protected void setPageNumber(long page_number) {
        this.getChildPage().setValue(page_number);
    }

    public String toString() {
        return RowUtil.toString(this.branchrow) + "child page: (" + String.valueOf(this.getChildPage()) + ")";
    }
}

