/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TriggerReferencingStruct;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class CreateTriggerNode
extends DDLStatementNode {
    private TableName triggerName;
    private TableName tableName;
    private int triggerEventMask;
    private ResultColumnList triggerCols;
    private boolean isBefore;
    private boolean isRow;
    private boolean isEnabled;
    private List<TriggerReferencingStruct> refClause;
    private ValueNode whenClause;
    private String whenText;
    private StatementNode actionNode;
    private String actionText;
    private String originalWhenText;
    private String originalActionText;
    private ProviderInfo[] providerInfo;
    private SchemaDescriptor triggerSchemaDescriptor;
    private SchemaDescriptor compSchemaDescriptor;
    private int[] referencedColInts;
    private int[] referencedColsInTriggerAction;
    private TableDescriptor triggerTableDescriptor;
    private String oldTableName;
    private String newTableName;
    private boolean oldTableInReferencingClause;
    private boolean newTableInReferencingClause;
    private final ArrayList<int[]> actionTransformations = new ArrayList();
    private final ArrayList<int[]> whenClauseTransformations = new ArrayList();
    private static final Comparator<FromBaseTable> OFFSET_COMPARATOR = new Comparator<FromBaseTable>(){

        @Override
        public int compare(FromBaseTable o1, FromBaseTable o2) {
            return o1.getTableNameField().getBeginOffset() - o2.getTableNameField().getBeginOffset();
        }
    };

    CreateTriggerNode(TableName triggerName, TableName tableName, int triggerEventMask, ResultColumnList triggerCols, boolean isBefore, boolean isRow, boolean isEnabled, List<TriggerReferencingStruct> refClause, ValueNode whenClause, String whenText, StatementNode actionNode, String actionText, ContextManager cm) throws StandardException {
        super(triggerName, cm);
        this.triggerName = triggerName;
        this.tableName = tableName;
        this.triggerEventMask = triggerEventMask;
        this.triggerCols = triggerCols;
        this.isBefore = isBefore;
        this.isRow = isRow;
        this.isEnabled = isEnabled;
        this.refClause = refClause;
        this.whenClause = whenClause;
        this.originalWhenText = whenText;
        this.whenText = whenText == null ? null : whenText.trim();
        this.actionNode = actionNode;
        this.originalActionText = actionText;
        this.actionText = actionText == null ? null : actionText.trim();
        this.implicitCreateSchema = true;
    }

    @Override
    String statementToString() {
        return "CREATE TRIGGER";
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.triggerCols != null) {
            this.printLabel(depth, "triggerColumns: ");
            this.triggerCols.treePrint(depth + 1);
        }
        if (this.whenClause != null) {
            this.printLabel(depth, "whenClause: ");
            this.whenClause.treePrint(depth + 1);
        }
        if (this.actionNode != null) {
            this.printLabel(depth, "actionNode: ");
            this.actionNode.treePrint(depth + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dd = this.getDataDictionary();
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        this.compSchemaDescriptor = lcc.getDefaultSchema();
        this.triggerSchemaDescriptor = this.getSchemaDescriptor();
        this.triggerTableDescriptor = this.getTableDescriptor(this.tableName);
        if (this.isSessionSchema(this.triggerTableDescriptor.getSchemaDescriptor())) {
            throw StandardException.newException((String)"XCL51.S", (Object[])new Object[0]);
        }
        if (this.isPrivilegeCollectionRequired()) {
            compilerContext.pushCurrentPrivType(5);
            compilerContext.addRequiredTablePriv(this.triggerTableDescriptor);
            compilerContext.popCurrentPrivType();
        }
        boolean needInternalSQL = this.bindReferencesClause(dd);
        SortedSet<TableName> actionNames = this.actionNode.getOffsetOrderedNodes(TableName.class);
        SortedSet<TableName> whenNames = this.whenClause != null ? this.whenClause.getOffsetOrderedNodes(TableName.class) : null;
        ProviderList prevAPL = compilerContext.getCurrentAuxiliaryProviderList();
        ProviderList apl = new ProviderList();
        lcc.pushTriggerTable(this.triggerTableDescriptor);
        try {
            compilerContext.setCurrentAuxiliaryProviderList(apl);
            if (needInternalSQL) {
                compilerContext.setReliability(0);
            }
            if (this.isBefore) {
                compilerContext.setReliability(2048);
            }
            this.actionNode.bindStatement();
            if (this.whenClause != null) {
                ContextManager cm = this.getContextManager();
                this.whenClause = this.whenClause.bindExpression(new FromList(cm), new SubqueryList(cm), new ArrayList<AggregateNode>(0));
                this.whenClause.checkIsBoolean();
            }
        }
        finally {
            lcc.popTriggerTable(this.triggerTableDescriptor);
            compilerContext.setCurrentAuxiliaryProviderList(prevAPL);
        }
        this.qualifyNames(actionNames, whenNames);
        compilerContext.createDependency(this.triggerTableDescriptor);
        if (this.triggerCols != null && this.triggerCols.size() != 0) {
            HashSet<String> columnNames = new HashSet<String>();
            for (ResultColumn rc : this.triggerCols) {
                if (!columnNames.add(rc.getName())) {
                    throw StandardException.newException((String)"42Y40", (Object[])new Object[]{rc.getName(), this.triggerName});
                }
                ColumnDescriptor cd = this.triggerTableDescriptor.getColumnDescriptor(rc.getName());
                if (cd != null) continue;
                throw StandardException.newException((String)"42X14", (Object[])new Object[]{rc.getName(), this.tableName});
            }
        }
        if (this.referencesSessionSchema()) {
            throw StandardException.newException((String)"XCL51.S", (Object[])new Object[0]);
        }
        DependencyManager dm = dd.getDependencyManager();
        this.providerInfo = dm.getPersistentProviderInfos(apl);
        dm.clearColumnInfoInProviders(apl);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return CreateTriggerNode.isSessionSchema(this.triggerTableDescriptor.getSchemaName()) || this.actionNode.referencesSessionSchema() || this.whenClause != null && this.whenClause.referencesSessionSchema();
    }

    private boolean bindReferencesClause(DataDictionary dd) throws StandardException {
        String transformedActionText;
        this.validateReferencesClause(dd);
        if (this.isBefore) {
            this.forbidActionsOnGenCols();
        }
        String transformedWhenText = null;
        if (this.triggerCols != null && this.triggerCols.size() != 0) {
            this.referencedColInts = new int[this.triggerCols.size()];
            for (int i = 0; i < this.triggerCols.size(); ++i) {
                ResultColumn rc = (ResultColumn)this.triggerCols.elementAt(i);
                ColumnDescriptor cd = this.triggerTableDescriptor.getColumnDescriptor(rc.getName());
                if (cd == null) {
                    throw StandardException.newException((String)"42X14", (Object[])new Object[]{rc.getName(), this.tableName});
                }
                this.referencedColInts[i] = cd.getPosition();
            }
            Arrays.sort(this.referencedColInts);
        }
        if (this.isRow) {
            this.referencedColsInTriggerAction = new int[this.triggerTableDescriptor.getNumberOfColumns()];
            Arrays.fill(this.referencedColsInTriggerAction, -1);
            int[] cols = this.getDataDictionary().examineTriggerNodeAndCols(this.actionNode, this.oldTableName, this.newTableName, this.originalActionText, this.referencedColInts, this.referencedColsInTriggerAction, this.actionNode.getBeginOffset(), this.triggerTableDescriptor, this.triggerEventMask, true, this.actionTransformations);
            if (this.whenClause != null) {
                cols = this.getDataDictionary().examineTriggerNodeAndCols(this.whenClause, this.oldTableName, this.newTableName, this.originalActionText, this.referencedColInts, this.referencedColsInTriggerAction, this.actionNode.getBeginOffset(), this.triggerTableDescriptor, this.triggerEventMask, true, this.actionTransformations);
            }
            transformedActionText = this.getDataDictionary().getTriggerActionString(this.actionNode, this.oldTableName, this.newTableName, this.originalActionText, this.referencedColInts, this.referencedColsInTriggerAction, this.actionNode.getBeginOffset(), this.triggerTableDescriptor, this.triggerEventMask, true, this.actionTransformations, cols);
            if (this.whenClause != null) {
                transformedWhenText = this.getDataDictionary().getTriggerActionString(this.whenClause, this.oldTableName, this.newTableName, this.originalWhenText, this.referencedColInts, this.referencedColsInTriggerAction, this.whenClause.getBeginOffset(), this.triggerTableDescriptor, this.triggerEventMask, true, this.whenClauseTransformations, cols);
            }
            this.referencedColsInTriggerAction = this.justTheRequiredColumns(this.referencedColsInTriggerAction);
        } else {
            transformedActionText = this.transformStatementTriggerText(this.actionNode, this.originalActionText, this.actionTransformations);
            if (this.whenClause != null) {
                transformedWhenText = this.transformStatementTriggerText(this.whenClause, this.originalWhenText, this.whenClauseTransformations);
            }
        }
        if (this.referencedColsInTriggerAction != null) {
            Arrays.sort(this.referencedColsInTriggerAction);
        }
        boolean regenNode = false;
        if (!transformedActionText.equals(this.actionText)) {
            regenNode = true;
            this.actionText = transformedActionText;
            this.actionNode = this.parseStatement(this.actionText, true);
        }
        if (this.whenClause != null && !transformedWhenText.equals(this.whenText)) {
            regenNode = true;
            this.whenText = transformedWhenText;
            this.whenClause = this.parseSearchCondition(this.whenText, true);
        }
        return regenNode;
    }

    private void qualifyNames(SortedSet<TableName> actionNames, SortedSet<TableName> whenNames) throws StandardException {
        StringBuilder original = new StringBuilder();
        StringBuilder transformed = new StringBuilder();
        this.qualifyNames(this.actionNode, actionNames, this.originalActionText, this.actionText, this.actionTransformations, original, transformed);
        this.originalActionText = original.toString();
        this.actionText = transformed.toString();
        if (this.whenClause != null) {
            original.setLength(0);
            transformed.setLength(0);
            this.qualifyNames(this.whenClause, whenNames, this.originalWhenText, this.whenText, this.whenClauseTransformations, original, transformed);
            this.originalWhenText = original.toString();
            this.whenText = transformed.toString();
        }
    }

    private void qualifyNames(QueryTreeNode node, SortedSet<TableName> tableNames, String originalText, String transformedText, List<int[]> replacements, StringBuilder newOriginal, StringBuilder newTransformed) throws StandardException {
        int originalPos = 0;
        int transformedPos = 0;
        for (TableName name : tableNames) {
            String qualifiedName = name.getFullSQLName();
            int beginOffset = name.getBeginOffset() - node.getBeginOffset();
            int tokenLength = name.getEndOffset() + 1 - name.getBeginOffset();
            newTransformed.append(transformedText, transformedPos, beginOffset);
            newTransformed.append(qualifiedName);
            transformedPos = beginOffset + tokenLength;
            Integer origBeginOffset = CreateTriggerNode.getOriginalPosition(replacements, beginOffset);
            if (origBeginOffset == null) continue;
            newOriginal.append(originalText, originalPos, (int)origBeginOffset);
            newOriginal.append(qualifiedName);
            originalPos = origBeginOffset + tokenLength;
        }
        newTransformed.append(transformedText, transformedPos, transformedText.length());
        newOriginal.append(originalText, originalPos, originalText.length());
    }

    private static Integer getOriginalPosition(List<int[]> replacements, int transformedPosition) {
        for (int i = replacements.size() - 1; i >= 0; --i) {
            int[] offsets = replacements.get(i);
            if (transformedPosition < offsets[2]) continue;
            if (transformedPosition < offsets[3]) {
                return null;
            }
            return offsets[1] + (transformedPosition - offsets[3]);
        }
        return transformedPosition;
    }

    private int[] justTheRequiredColumns(int[] columnsArrary) {
        int countOfColsRefedInArray = 0;
        int numberOfColsInTriggerTable = this.triggerTableDescriptor.getNumberOfColumns();
        for (int i = 0; i < numberOfColsInTriggerTable; ++i) {
            if (columnsArrary[i] == -1) continue;
            ++countOfColsRefedInArray;
        }
        if (countOfColsRefedInArray > 0) {
            int[] tempArrayOfNeededColumns = new int[countOfColsRefedInArray];
            int j = 0;
            for (int i = 0; i < numberOfColsInTriggerTable; ++i) {
                if (columnsArrary[i] == -1) continue;
                tempArrayOfNeededColumns[j++] = columnsArrary[i];
            }
            return tempArrayOfNeededColumns;
        }
        return null;
    }

    private String transformStatementTriggerText(QueryTreeNode node, String originalText, List<int[]> replacements) throws StandardException {
        int offset = node.getBeginOffset();
        int start = 0;
        StringBuilder newText = new StringBuilder();
        for (FromBaseTable fromTable : this.getTransitionTables(node)) {
            String baseTableName = fromTable.getBaseTableName();
            int tokBeginOffset = fromTable.getTableNameField().getBeginOffset();
            int tokEndOffset = fromTable.getTableNameField().getEndOffset();
            int nextTokenStart = tokEndOffset - offset + 1;
            this.checkInvalidTriggerReference(baseTableName);
            newText.append(originalText, start, tokBeginOffset - offset);
            int replacementOffset = newText.length();
            newText.append(baseTableName.equals(this.oldTableName) ? "new org.apache.derby.catalog.TriggerOldTransitionRows() " : "new org.apache.derby.catalog.TriggerNewTransitionRows() ");
            if (fromTable.getCorrelationName() == null) {
                newText.append(baseTableName).append(' ');
            }
            replacements.add(new int[]{tokBeginOffset - offset, nextTokenStart, replacementOffset, newText.length()});
            start = nextTokenStart;
        }
        newText.append(originalText, start, originalText.length());
        return newText.toString();
    }

    private SortedSet<FromBaseTable> getTransitionTables(Visitable node) throws StandardException {
        CollectNodesVisitor<FromBaseTable> visitor = new CollectNodesVisitor<FromBaseTable>(FromBaseTable.class);
        node.accept(visitor);
        TreeSet<FromBaseTable> tables = new TreeSet<FromBaseTable>(OFFSET_COMPARATOR);
        for (FromBaseTable fbt : visitor.getList()) {
            int tokBeginOffset;
            if (!this.isTransitionTable(fbt) || (tokBeginOffset = fbt.getTableNameField().getBeginOffset()) == -1) continue;
            tables.add(fbt);
        }
        return tables;
    }

    private boolean isTransitionTable(FromBaseTable fbt) {
        String baseTableName;
        if (!fbt.getOrigTableName().hasSchema() && (baseTableName = fbt.getBaseTableName()) != null) {
            return baseTableName.equals(this.oldTableName) || baseTableName.equals(this.newTableName);
        }
        return false;
    }

    private void forbidActionsOnGenCols() throws StandardException {
        ColumnDescriptorList generatedColumns = this.triggerTableDescriptor.getGeneratedColumns();
        int genColCount = generatedColumns.size();
        if (genColCount == 0) {
            return;
        }
        CollectNodesVisitor<ColumnReference> visitor = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        this.actionNode.accept(visitor);
        if (this.whenClause != null) {
            this.whenClause.accept(visitor);
        }
        for (ColumnReference cr : visitor.getList()) {
            String colRefName = cr.getColumnName();
            String tabRefName = cr.getTableName();
            for (int gc_idx = 0; gc_idx < genColCount; ++gc_idx) {
                String genColName = generatedColumns.elementAt(gc_idx).getColumnName();
                if (!genColName.equals(colRefName) || !this.equals(this.newTableName, tabRefName)) continue;
                throw StandardException.newException((String)"42XAA", (Object[])new Object[]{genColName});
            }
        }
    }

    private boolean equals(String left, String right) {
        if (left == null) {
            return right == null;
        }
        return left.equals(right);
    }

    private void checkInvalidTriggerReference(String tableName) throws StandardException {
        if (tableName.equals(this.oldTableName) && (this.triggerEventMask & 4) == 4) {
            throw StandardException.newException((String)"42Y92", (Object[])new Object[]{"INSERT", "new"});
        }
        if (tableName.equals(this.newTableName) && (this.triggerEventMask & 2) == 2) {
            throw StandardException.newException((String)"42Y92", (Object[])new Object[]{"DELETE", "old"});
        }
    }

    private void validateReferencesClause(DataDictionary dd) throws StandardException {
        if (this.refClause == null || this.refClause.isEmpty()) {
            return;
        }
        for (TriggerReferencingStruct trn : this.refClause) {
            if (this.isRow && !trn.isRow) {
                throw StandardException.newException((String)"42Y92", (Object[])new Object[]{"ROW", "row"});
            }
            if (!this.isRow && trn.isRow) {
                throw StandardException.newException((String)"42Y92", (Object[])new Object[]{"STATEMENT", "table"});
            }
            if (trn.isNew) {
                if (this.newTableInReferencingClause) {
                    throw StandardException.newException((String)"42Y93", (Object[])new Object[0]);
                }
                if ((this.triggerEventMask & 2) == 2) {
                    throw StandardException.newException((String)"42Y92", (Object[])new Object[]{"DELETE", "old"});
                }
                this.newTableName = trn.identifier;
                this.newTableInReferencingClause = true;
            } else {
                if (this.oldTableInReferencingClause) {
                    throw StandardException.newException((String)"42Y93", (Object[])new Object[0]);
                }
                if ((this.triggerEventMask & 4) == 4) {
                    throw StandardException.newException((String)"42Y92", (Object[])new Object[]{"INSERT", "new"});
                }
                this.oldTableName = trn.identifier;
                this.oldTableInReferencingClause = true;
            }
            if (!this.isBefore || trn.isRow) continue;
            throw StandardException.newException((String)"42Y92", (Object[])new Object[]{"BEFORE", "row"});
        }
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        String oldReferencingName = this.oldTableInReferencingClause ? this.oldTableName : null;
        String newReferencingName = this.newTableInReferencingClause ? this.newTableName : null;
        return this.getGenericConstantActionFactory().getCreateTriggerConstantAction(this.triggerSchemaDescriptor.getSchemaName(), this.getRelativeName(), this.triggerEventMask, this.isBefore, this.isRow, this.isEnabled, this.triggerTableDescriptor, null, this.whenText, null, this.actionText, this.compSchemaDescriptor.getUUID(), this.referencedColInts, this.referencedColsInTriggerAction, this.originalWhenText, this.originalActionText, this.oldTableInReferencingClause, this.newTableInReferencingClause, oldReferencingName, newReferencingName, this.providerInfo);
    }

    @Override
    public String toString() {
        String refString = "null";
        if (this.refClause != null) {
            StringBuilder buf = new StringBuilder();
            for (TriggerReferencingStruct trn : this.refClause) {
                buf.append("\t");
                buf.append(trn.toString());
                buf.append("\n");
            }
            refString = buf.toString();
        }
        return super.toString() + "tableName: " + String.valueOf(this.tableName) + "\ntriggerEventMask: " + this.triggerEventMask + "\nisBefore: " + this.isBefore + "\nisRow: " + this.isRow + "\nisEnabled: " + this.isEnabled + "\nwhenText: " + this.whenText + "\nrefClause: " + refString + "\nactionText: " + this.actionText + "\n";
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.triggerName != null) {
            this.triggerName = (TableName)this.triggerName.accept(v);
        }
        if (this.tableName != null) {
            this.tableName = (TableName)this.tableName.accept(v);
        }
    }
}

