/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.LockOwner;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockTable;
import org.apache.derby.shared.common.sanity.SanityManager;

final class LockControl
implements Control {
    private final Lockable ref;
    private Lock firstGrant;
    private List<Lock> granted;
    private List<Lock> waiting;
    private Lock lastPossibleSkip;

    protected LockControl(Lock firstLock, Lockable ref) {
        this.ref = ref;
        this.firstGrant = firstLock;
    }

    private LockControl(LockControl copyFrom) {
        this.ref = copyFrom.ref;
        this.firstGrant = copyFrom.firstGrant;
        if (copyFrom.granted != null) {
            this.granted = new LinkedList<Lock>(copyFrom.granted);
        }
        if (copyFrom.waiting != null) {
            this.waiting = new LinkedList<Lock>(copyFrom.waiting);
        }
        this.lastPossibleSkip = copyFrom.lastPossibleSkip;
    }

    @Override
    public LockControl getLockControl() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        if (!this.isUnlocked()) {
            return false;
        }
        return this.waiting == null || this.waiting.isEmpty();
    }

    void grant(Lock lockItem) {
        lockItem.grant();
        List<Lock> lgranted = this.granted;
        if (lgranted == null) {
            if (this.firstGrant == null) {
                this.firstGrant = lockItem;
            } else {
                lgranted = this.granted = new LinkedList<Lock>();
                lgranted.add(this.firstGrant);
                lgranted.add(lockItem);
                this.firstGrant = null;
            }
        } else {
            lgranted.add(lockItem);
        }
    }

    @Override
    public boolean unlock(Latch lockInGroup, int unlockCount) {
        if (unlockCount == 0) {
            unlockCount = lockInGroup.getCount();
        }
        List<Lock> lgranted = this.granted;
        int index = 0;
        while (unlockCount > 0) {
            Lock lockInSet;
            if (this.firstGrant != null) {
                SanityManager.ASSERT((boolean)lockInGroup.equals(this.firstGrant));
                lockInSet = this.firstGrant;
            } else {
                index = lgranted.indexOf(lockInGroup);
                SanityManager.ASSERT((index != -1 ? 1 : 0) != 0);
                lockInSet = lgranted.get(index);
            }
            unlockCount -= lockInSet.unlock(unlockCount);
            if (lockInSet.getCount() != 0) {
                if (unlockCount == 0) continue;
                SanityManager.THROWASSERT((String)("locked item didn't reduce unlock count to zero " + unlockCount));
                continue;
            }
            if (this.firstGrant == lockInSet) {
                if (unlockCount != 0) {
                    SanityManager.THROWASSERT((String)("item is still locked! " + unlockCount));
                }
                this.firstGrant = null;
                continue;
            }
            lgranted.remove(index);
        }
        return true;
    }

    @Override
    public boolean isGrantable(boolean noWaitersBeforeMe, CompatibilitySpace compatibilitySpace, Object qualifier) {
        if (this.isUnlocked()) {
            return true;
        }
        boolean grantLock = false;
        Lockable lref = this.ref;
        List<Lock> lgranted = this.granted;
        boolean selfCompatible = lref.lockerAlwaysCompatible();
        int index = 0;
        int endIndex = this.firstGrant == null ? lgranted.size() : 0;
        do {
            boolean sameSpace;
            Lock gl = this.firstGrant == null ? lgranted.get(index) : this.firstGrant;
            boolean bl = sameSpace = gl.getCompatabilitySpace() == compatibilitySpace;
            if (sameSpace && selfCompatible) {
                grantLock = true;
                continue;
            }
            if (!lref.requestCompatible(qualifier, gl.getQualifier())) {
                grantLock = false;
                break;
            }
            if (!sameSpace && !noWaitersBeforeMe) continue;
            grantLock = true;
        } while (++index < endIndex);
        return grantLock;
    }

    public Lock addLock(LockTable ls, CompatibilitySpace compatibilitySpace, Object qualifier) {
        if (this.isUnlocked() && this.firstWaiter() == null) {
            SanityManager.THROWASSERT((String)("entered in totally unlocked mode " + this.isUnlocked() + " " + (this.firstWaiter() != null)));
        }
        boolean grantLock = false;
        boolean otherWaiters = this.firstWaiter() != null;
        Lock lockItem = null;
        Lockable lref = this.ref;
        boolean spaceHasALock = false;
        boolean noGrantAtAll = false;
        if (!this.isUnlocked()) {
            boolean selfCompatible = lref.lockerAlwaysCompatible();
            int index = 0;
            int endIndex = this.firstGrant == null ? this.granted.size() : 0;
            do {
                boolean sameSpace;
                Lock gl = this.firstGrant == null ? this.granted.get(index) : this.firstGrant;
                boolean bl = sameSpace = gl.getCompatabilitySpace() == compatibilitySpace;
                if (sameSpace && selfCompatible) {
                    spaceHasALock = true;
                    if (noGrantAtAll) break;
                    if (qualifier == gl.getQualifier()) {
                        lockItem = gl;
                    }
                    grantLock = true;
                    continue;
                }
                if (!lref.requestCompatible(qualifier, gl.getQualifier())) {
                    grantLock = false;
                    lockItem = null;
                    if (spaceHasALock) break;
                    noGrantAtAll = true;
                }
                if (noGrantAtAll || !sameSpace && otherWaiters) continue;
                grantLock = true;
            } while (++index < endIndex);
        }
        if (lockItem != null) {
            if (!grantLock) {
                SanityManager.THROWASSERT((String)("lock is not granted !" + String.valueOf(lockItem)));
            }
            ++lockItem.count;
            return lockItem;
        }
        if (grantLock) {
            lockItem = new Lock(compatibilitySpace, lref, qualifier);
            this.grant(lockItem);
            return lockItem;
        }
        ActiveLock waitingLock = new ActiveLock(compatibilitySpace, lref, qualifier);
        if (spaceHasALock) {
            waitingLock.canSkip = true;
        }
        if (this.waiting == null) {
            this.waiting = new LinkedList<Lock>();
        }
        this.addWaiter(waitingLock, ls);
        if (waitingLock.canSkip) {
            this.lastPossibleSkip = waitingLock;
        }
        return waitingLock;
    }

    protected boolean isUnlocked() {
        if (this.firstGrant != null) {
            return false;
        }
        List<Lock> lgranted = this.granted;
        return lgranted == null || lgranted.isEmpty();
    }

    @Override
    public ActiveLock firstWaiter() {
        if (this.waiting == null || this.waiting.isEmpty()) {
            return null;
        }
        return (ActiveLock)this.waiting.get(0);
    }

    ActiveLock getNextWaiter(ActiveLock item, boolean remove, LockTable ls) {
        int count;
        ActiveLock nextWaitingLock = null;
        if (remove && this.waiting.get(0) == item) {
            this.popFrontWaiter(ls);
            nextWaitingLock = this.firstWaiter();
        } else if (this.lastPossibleSkip != null && this.lastPossibleSkip != item) {
            int removeIndex;
            int itemIndex = this.waiting.indexOf(item);
            int n = removeIndex = remove ? itemIndex : -1;
            if (itemIndex != this.waiting.size() - 1) {
                ListIterator<Lock> li = this.waiting.listIterator(itemIndex + 1);
                while (li.hasNext()) {
                    ActiveLock al = (ActiveLock)li.next();
                    if (!al.canSkip) continue;
                    nextWaitingLock = al;
                    break;
                }
            }
            if (remove) {
                this.removeWaiter(removeIndex, ls);
            }
        } else if (remove && (count = this.removeWaiter(item, ls)) != 1) {
            SanityManager.THROWASSERT((String)("count = " + count + "item = " + String.valueOf(item) + "waiting = " + String.valueOf(this.waiting)));
        }
        if (remove && item == this.lastPossibleSkip) {
            this.lastPossibleSkip = null;
        }
        if (nextWaitingLock != null && !nextWaitingLock.setPotentiallyGranted()) {
            nextWaitingLock = null;
        }
        return nextWaitingLock;
    }

    @Override
    public Lockable getLockable() {
        return this.ref;
    }

    @Override
    public Lock getFirstGrant() {
        return this.firstGrant;
    }

    @Override
    public List<Lock> getGranted() {
        return this.granted;
    }

    @Override
    public List<Lock> getWaiting() {
        return this.waiting;
    }

    protected void giveUpWait(Object item, LockTable ls) {
        int count = this.removeWaiter(item, ls);
        if (item == this.lastPossibleSkip) {
            this.lastPossibleSkip = null;
        }
        if (count != 1) {
            SanityManager.THROWASSERT((String)("count = " + count + "item = " + String.valueOf(item) + "waiting = " + String.valueOf(this.waiting)));
        }
    }

    @Override
    public void addWaiters(Map<Object, Object> waiters) {
        if (this.waiting == null || this.waiting.isEmpty()) {
            return;
        }
        Control previous = this;
        ListIterator<Lock> li = this.waiting.listIterator();
        while (li.hasNext()) {
            ActiveLock waitingLock = (ActiveLock)li.next();
            CompatibilitySpace waiter = waitingLock.getCompatabilitySpace();
            waiters.put(waiter, waitingLock);
            waiters.put(waitingLock, previous);
            previous = waitingLock;
        }
    }

    List<Lock> getGrants() {
        LinkedList<Lock> ret;
        if (this.firstGrant != null) {
            ret = new LinkedList<Lock>();
            ret.add(this.firstGrant);
        } else {
            ret = new LinkedList<Lock>(this.granted);
        }
        return ret;
    }

    @Override
    public final Lock getLock(CompatibilitySpace compatibilitySpace, Object qualifier) {
        if (this.isUnlocked()) {
            return null;
        }
        List<Lock> lgranted = this.granted;
        int index = 0;
        int endIndex = this.firstGrant == null ? lgranted.size() : 0;
        do {
            Lock gl;
            Lock lock = gl = this.firstGrant == null ? lgranted.get(index) : this.firstGrant;
            if (gl.getCompatabilitySpace() != compatibilitySpace || gl.getQualifier() != qualifier) continue;
            return gl;
        } while (++index < endIndex);
        return null;
    }

    public boolean blockedByParent(Lock childLock) {
        if (this.granted == null) {
            return false;
        }
        LockOwner childOwner = childLock.getCompatabilitySpace().getOwner();
        Object requestedQualifier = childLock.getQualifier();
        for (Lock grantedLock : this.granted) {
            LockOwner ownerOfGrant = grantedLock.getCompatabilitySpace().getOwner();
            if (!childOwner.nestsUnder(ownerOfGrant)) continue;
            Object grantedQualifier = grantedLock.getQualifier();
            if (grantedLock.getLockable().requestCompatible(requestedQualifier, grantedQualifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Control shallowClone() {
        return new LockControl(this);
    }

    private void addWaiter(Lock lockItem, LockTable ls) {
        this.waiting.add(lockItem);
        ls.oneMoreWaiter();
    }

    private Object popFrontWaiter(LockTable ls) {
        return this.removeWaiter(0, ls);
    }

    private Object removeWaiter(int index, LockTable ls) {
        ls.oneLessWaiter();
        return this.waiting.remove(index);
    }

    private int removeWaiter(Object item, LockTable ls) {
        ls.oneLessWaiter();
        return this.waiting.remove(item) ? 1 : 0;
    }
}

