/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.derby.iapi.services.classfile.CONSTANT_Index_info;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.classfile.ConstantPoolEntry;

class ClassEnumeration
implements Enumeration {
    ClassHolder cpt;
    Enumeration inner;
    CONSTANT_Index_info position;
    HashSet<String> foundClasses;
    Enumeration classList;

    ClassEnumeration(ClassHolder cpt, Enumeration e, Enumeration methods, Enumeration fields) {
        this.cpt = cpt;
        this.inner = e;
        this.foundClasses = new HashSet(30, 0.8f);
        this.findMethodReferences(methods, this.foundClasses);
        this.findFieldReferences(fields, this.foundClasses);
        this.findClassReferences(this.foundClasses);
        this.classList = Collections.enumeration(this.foundClasses);
    }

    @Override
    public boolean hasMoreElements() {
        return this.classList.hasMoreElements();
    }

    private void findClassReferences(HashSet<String> foundClasses) {
        while (this.inner.hasMoreElements()) {
            ConstantPoolEntry item = (ConstantPoolEntry)this.inner.nextElement();
            if (item == null || item.getTag() != 7) continue;
            CONSTANT_Index_info ref = (CONSTANT_Index_info)item;
            String className = this.cpt.className(ref.getIndex());
            if (className.startsWith("[")) {
                this.distillClasses(className, foundClasses);
                continue;
            }
            if (className.length() <= 1 || className.startsWith("java")) continue;
            foundClasses.add(className);
        }
    }

    private void findMethodReferences(Enumeration methods, HashSet<String> foundClasses) {
        while (methods.hasMoreElements()) {
            ClassMember member = (ClassMember)methods.nextElement();
            String description = member.getDescriptor();
            this.distillClasses(description, foundClasses);
        }
    }

    private void findFieldReferences(Enumeration fields, HashSet<String> foundClasses) {
        while (fields.hasMoreElements()) {
            ClassMember member = (ClassMember)fields.nextElement();
            String description = member.getDescriptor();
            this.distillClasses(description, foundClasses);
        }
    }

    void distillClasses(String fieldOrMethodSig, HashSet<String> foundClasses) {
        if (fieldOrMethodSig == null || fieldOrMethodSig.length() < 1) {
            return;
        }
        if (fieldOrMethodSig.charAt(0) != '(') {
            int classNameStart = fieldOrMethodSig.indexOf(76);
            if (classNameStart == -1) {
                return;
            }
            String fieldType = fieldOrMethodSig.substring(classNameStart + 1).replace('/', '.');
            if (fieldType.endsWith(";")) {
                fieldType = fieldType.substring(0, fieldType.length() - 1);
            }
            if (fieldType.startsWith("java")) {
                return;
            }
            foundClasses.add(fieldType);
            return;
        }
        StringTokenizer tokens = new StringTokenizer(fieldOrMethodSig, "();[");
        while (tokens.hasMoreElements()) {
            String aToken = tokens.nextToken();
            int classNameStart = aToken.indexOf(76);
            if (classNameStart == -1) continue;
            this.distillClasses(aToken, foundClasses);
        }
    }

    public Object nextElement() {
        return this.classList.nextElement();
    }
}

