/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.shared.common.error.StandardException;

abstract class DiagUtil {
    DiagUtil() {
    }

    static void checkAccess() throws StandardException {
        String currentUser;
        String databaseOwner;
        LanguageConnectionContext lcc = (LanguageConnectionContext)DiagUtil.getContextOrNull("LanguageConnectionContext");
        DataDictionary dd = lcc.getDataDictionary();
        if (dd.usesSqlAuthorization() && !(databaseOwner = dd.getAuthorizationDatabaseOwner()).equals(currentUser = lcc.getStatementContext().getSQLSessionContext().getCurrentUser())) {
            throw StandardException.newException((String)"4251D", (Object[])new Object[0]);
        }
    }

    private static Context getContextOrNull(final String contextID) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContextOrNull(contextID);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(contextID);
            }
        });
    }
}

