"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildEsqlQuery = void 0;
var _streamlang = require("@kbn/streamlang");
var _esqlAst = require("@kbn/esql-ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildEsqlQuery = (indices, query, includeMetadata = false) => {
  const fromCommand = _esqlAst.Builder.command({
    name: 'from',
    args: [_esqlAst.Builder.expression.source.index(indices.join(',')), ...(includeMetadata ? [_esqlAst.Builder.option({
      name: 'METADATA',
      args: [_esqlAst.Builder.expression.column({
        args: [_esqlAst.Builder.identifier({
          name: '_id'
        })]
      }), _esqlAst.Builder.expression.column({
        args: [_esqlAst.Builder.identifier('_source')]
      })]
    })] : [])]
  });
  const kqlQuery = _esqlAst.Builder.expression.func.call('KQL', [_esqlAst.Builder.expression.literal.string(query.kql.query)]);
  const whereCondition = query.feature ? _esqlAst.Builder.expression.func.binary('and', [kqlQuery, _esqlAst.Builder.expression.literal.string((0, _streamlang.conditionToESQL)(query.feature.filter), {
    unquoted: true
  })]) : kqlQuery;
  const whereCommand = _esqlAst.Builder.command({
    name: 'where',
    args: [whereCondition]
  });
  const esqlQuery = _esqlAst.Builder.expression.query([fromCommand, whereCommand]);
  return _esqlAst.BasicPrettyPrinter.print(esqlQuery);
};
exports.buildEsqlQuery = buildEsqlQuery;