"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInheritedSettings = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInheritedSettings = ancestors => {
  return ancestors.reduce((acc, def) => {
    Object.entries(def.ingest.settings).forEach(([key, value]) => {
      acc[key] = {
        ...value,
        from: def.name
      };
    });
    return acc;
  }, {});
};
exports.getInheritedSettings = getInheritedSettings;