"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inheritedFieldDefinitionSchema = exports.fieldDefinitionSchema = exports.fieldDefinitionConfigSchema = exports.FIELD_DEFINITION_TYPES = void 0;
exports.isMappingProperties = isMappingProperties;
exports.namedFieldDefinitionConfigSchema = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _record_types = require("../shared/record_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELD_DEFINITION_TYPES = exports.FIELD_DEFINITION_TYPES = ['keyword', 'match_only_text', 'long', 'double', 'date', 'boolean', 'ip'];

// We redefine "first class" parameters

// Parameters that we provide a generic (JSON blob) experience for

const fieldDefinitionConfigSchema = exports.fieldDefinitionConfigSchema = _zod.z.intersection(_record_types.recursiveRecord, _zod.z.union([_zod.z.object({
  type: _zod.z.enum(FIELD_DEFINITION_TYPES),
  format: _zod.z.optional(_zodHelpers.NonEmptyString)
}), _zod.z.object({
  type: _zod.z.literal('system')
})]));
function isMappingProperties(value) {
  return Object.values(value).every(prop => prop.type !== 'system');
}
const fieldDefinitionSchema = exports.fieldDefinitionSchema = _zod.z.record(_zod.z.string(), fieldDefinitionConfigSchema);
const inheritedFieldDefinitionSchema = exports.inheritedFieldDefinitionSchema = _zod.z.record(_zod.z.string(), _zod.z.intersection(fieldDefinitionConfigSchema, _zod.z.object({
  from: _zodHelpers.NonEmptyString,
  alias_for: _zod.z.optional(_zodHelpers.NonEmptyString)
})));
const namedFieldDefinitionConfigSchema = exports.namedFieldDefinitionConfigSchema = _zod.z.intersection(fieldDefinitionConfigSchema, _zod.z.object({
  name: _zodHelpers.NonEmptyString
}));