"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsTelemetryService = void 0;
var _streams_usage_collector = require("./streams_usage_collector");
var _streams_storage_client = require("../../streams/storage/streams_storage_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Service for collecting Streams usage statistics for telemetry
 */
class StatsTelemetryService {
  constructor() {}
  setup(core, logger, usageCollection) {
    if (!usageCollection) {
      logger.debug('[Streams Stats Telemetry Service] Usage collection not available, skipping setup');
      return;
    }
    logger.debug('[Streams Stats Telemetry Service] Setting up streams usage collector');

    // Provide a reader factory so future methods can share the same storage client
    (0, _streams_usage_collector.registerStreamsUsageCollector)(usageCollection, logger, () => this.getUsageReader(core, logger));
  }
  async getUsageReader(core, logger) {
    const [coreStart] = await core.getStartServices();
    const esClient = coreStart.elasticsearch.client.asInternalUser;
    const storageClient = (0, _streams_storage_client.createStreamsStorageClient)(esClient, logger);
    return {
      async readAllManagedStreams() {
        const results = [];
        const pageSize = 2000; // To avoid ES circuit_breaker_exception
        let from = 0;
        while (true) {
          const resp = await storageClient.search({
            from,
            size: pageSize,
            track_total_hits: false,
            query: {
              match_all: {}
            }
          });
          const hits = resp.hits.hits;
          if (hits.length === 0) {
            break;
          }
          for (const {
            _source
          } of hits) {
            if (_source) {
              results.push(_source);
            }
          }
          if (hits.length < pageSize) {
            break;
          }
          from += pageSize;
        }
        return results;
      }
    };
  }
}
exports.StatsTelemetryService = StatsTelemetryService;