"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateRoutingIfConditionToStreamlang = exports.migrateOldProcessingArrayToStreamlang = void 0;
var _streamlang = require("@kbn/streamlang");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migrateRoutingIfConditionToStreamlang = definition => {
  const routingArr = definition.ingest.wired.routing;
  const migratedRouting = routingArr.map(route => {
    const {
      if: oldIf,
      ...rest
    } = route;
    const where = recursivelyConvertCondition(oldIf);
    return {
      ...rest,
      where
    };
  });
  return {
    ...definition,
    ingest: {
      ...(typeof definition.ingest === 'object' && definition.ingest !== null ? definition.ingest : {}),
      wired: {
        ...definition.ingest.wired,
        routing: migratedRouting
      }
    }
  };
};
exports.migrateRoutingIfConditionToStreamlang = migrateRoutingIfConditionToStreamlang;
const migrateOldProcessingArrayToStreamlang = definition => {
  const oldProcessing = typeof definition.ingest === 'object' && definition.ingest !== null && 'processing' in definition.ingest ? definition.ingest.processing : undefined;

  // Arrays to collect manual_ingest_pipeline processors and others
  const manualIngestPipelineProcessors = [];
  const otherProcessors = [];
  if (Array.isArray(oldProcessing)) {
    oldProcessing.forEach(proc => {
      var _manual_ingest_pipeli;
      if (proc && typeof proc === 'object' && 'manual_ingest_pipeline' in proc && Array.isArray((_manual_ingest_pipeli = proc.manual_ingest_pipeline) === null || _manual_ingest_pipeli === void 0 ? void 0 : _manual_ingest_pipeli.processors)) {
        const streamlangManualIngestPipeline = {
          action: 'manual_ingest_pipeline',
          processors: proc.manual_ingest_pipeline.processors,
          description: proc.manual_ingest_pipeline.description,
          ignore_failure: proc.manual_ingest_pipeline.ignore_failure,
          where: recursivelyConvertCondition(proc.manual_ingest_pipeline.if),
          tag: proc.manual_ingest_pipeline.tag,
          on_failure: proc.on_failure
        };
        // Use manual_ingest_pipeline processor as is once converted to Streamlang
        manualIngestPipelineProcessors.push(streamlangManualIngestPipeline);
      } else if (proc) {
        const type = Object.keys(proc)[0];
        const config = proc[type];

        // Collect other processor types
        otherProcessors.push({
          [type]: {
            ...config,
            ...('if' in config ? {
              if: (0, _streamlang.conditionToPainless)(recursivelyConvertCondition(config.if))
            } : {})
          }
        });
      }
    });

    // If there are any other processors, merge them into a single manual_ingest_pipeline processor
    if (otherProcessors.length > 0) {
      const streamlangManualIngestPipeline = {
        action: 'manual_ingest_pipeline',
        processors: otherProcessors,
        ignore_failure: true,
        where: _streamlang.ALWAYS_CONDITION
      };
      manualIngestPipelineProcessors.push(streamlangManualIngestPipeline);
    }
  }

  // Convert to StreamlangDSL steps
  const newProcessing = {
    steps: manualIngestPipelineProcessors
  };
  return {
    ...definition,
    ingest: {
      ...(typeof definition.ingest === 'object' ? definition.ingest : {}),
      processing: newProcessing
    }
  };
};

/** Drills down until we find filter conditions and converts from the old
 * syntax to the new Streamlang syntax.
 */
exports.migrateOldProcessingArrayToStreamlang = migrateOldProcessingArrayToStreamlang;
const recursivelyConvertCondition = condition => {
  if ('and' in condition) {
    return {
      and: condition.and.map(recursivelyConvertCondition)
    };
  }
  if ('or' in condition) {
    return {
      or: condition.or.map(recursivelyConvertCondition)
    };
  }
  if ('always' in condition) {
    return {
      always: {}
    };
  }
  if ('never' in condition) {
    return {
      never: {}
    };
  }
  const newOperator = condition.operator === 'exists' || condition.operator === 'notExists' ? 'exists' : condition.operator;
  const newValue = condition.operator === 'exists' ? true : condition.operator === 'notExists' ? false : 'value' in condition ? condition.value : undefined;

  // If it's a filter condition, convert formats.
  return {
    field: condition.field,
    [newOperator]: newValue
  };
};

/**
 * These are just simplified versions of the old types to provide some type safety.
 */
/** Deprecated */

/** Deprecated */

/** Deprecated */

/** Deprecated */

/** Deprecated */

/** Deprecated */

/** Deprecated */

/** Deprecated */

/** Deprecated */

/** Deprecated */
/** Holds a single key with a processor type, e.g. grok, date etc */