"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateDataQuality = calculateDataQuality;
var _public = require("@kbn/dataset-quality-plugin/public");
var _common = require("@kbn/dataset-quality-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function calculateDataQuality({
  totalDocs,
  degradedDocs,
  failedDocs
}) {
  const degradedPercentage = (0, _public.calculatePercentage)({
    totalDocs,
    count: degradedDocs
  });
  const failedPercentage = (0, _public.calculatePercentage)({
    totalDocs,
    count: failedDocs
  });
  const quality = (0, _common.mapPercentageToQuality)([degradedPercentage, failedPercentage]);
  return quality;
}