"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWaitingForAiMessage = useWaitingForAiMessage;
var _i18n = require("@kbn/i18n");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MESSAGE_BUCKETS = {
  5: [_i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.5s.1', {
    defaultMessage: 'Processing request...'
  }), _i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.5s.2', {
    defaultMessage: 'Formulating an execution plan...'
  })],
  10: [_i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.10s.1', {
    defaultMessage: 'Generating an optimized Elasticsearch query...'
  }), _i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.10s.2', {
    defaultMessage: 'Clustering your data...'
  })],
  15: [_i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.15s.1', {
    defaultMessage: 'Executing query against your data...'
  }), _i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.15s.2', {
    defaultMessage: 'Fetching more data for analysis...'
  })],
  20: [_i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.20s.1', {
    defaultMessage: 'Analyzing query results...'
  })],
  25: [_i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.25s.1', {
    defaultMessage: 'Correlating events...'
  }), _i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.25s.2', {
    defaultMessage: 'Synthesizing findings...'
  })],
  30: [_i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.30s.1', {
    defaultMessage: 'Generating a natural language summary...'
  })],
  35: [_i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.35s.1', {
    defaultMessage: 'Verifying the accuracy of the findings...'
  })],
  40: [_i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.40s.1', {
    defaultMessage: 'Compiling insights into a final response...'
  })],
  45: [_i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.45s.1', {
    defaultMessage: 'The analysis is taking longer than usual but is still progressing.'
  })]
};
function useWaitingForAiMessage(hasInitialResults = false) {
  const [elapsed, setElapsed] = (0, _react.useState)(0);
  (0, _react.useEffect)(() => {
    const interval = setInterval(() => {
      setElapsed(prev => {
        const next = prev + 5;
        if (next > 60) {
          clearInterval(interval);
          return 60;
        }
        return next;
      });
    }, 5000);
    return () => clearInterval(interval);
  }, [elapsed]);
  if (elapsed < 5) {
    return hasInitialResults ? _i18n.i18n.translate('xpack.streams.aiFlowWaitingForGeneration.generatingWhileReviewingLabel', {
      defaultMessage: "We'll keep generating while you review the initial results"
    }) : _i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.generatingSuggestionsLabel', {
      defaultMessage: 'Generating suggestions...'
    });
  }
  const bucket = Math.min(Math.floor(elapsed / 5) * 5, 45);
  const messages = MESSAGE_BUCKETS[bucket] || [];
  const index = Math.floor(Math.random() * messages.length);
  return messages[index] || _i18n.i18n.translate('xpack.streams.useWaitingForAiMessage.generatingSuggestionsLabel', {
    defaultMessage: 'Generating suggestions...'
  });
}