"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateStreams = void 0;
var _reactHooks = require("@kbn/react-hooks");
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateStreams = name => {
  const {
    signal
  } = (0, _reactHooks.useAbortController)();
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _react.useCallback)(async request => {
    await streamsRepositoryClient.fetch('PUT /api/streams/{name} 2023-10-31', {
      signal,
      params: {
        path: {
          name
        },
        body: request
      }
    });
  }, [name, signal, streamsRepositoryClient]);
};
exports.useUpdateStreams = useUpdateStreams;