"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailView = StreamDetailView;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireDefault(require("react"));
var _use_stream_detail = require("../../hooks/use_stream_detail");
var _use_streams_app_params = require("../../hooks/use_streams_app_params");
var _use_streams_app_router = require("../../hooks/use_streams_app_router");
var _use_streams_privileges = require("../../hooks/use_streams_privileges");
var _redirect_to = require("../redirect_to");
var _stream_badges = require("../stream_badges");
var _stream_detail_dashboards_view = require("../stream_detail_dashboards_view");
var _stream_detail_overview = require("../stream_detail_overview");
var _streams_app_page_template = require("../streams_app_page_template");
var _description = require("./description");
var _feedback_button = require("../feedback_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getStreamDetailTabs = ({
  definition,
  router,
  features
}) => ({
  overview: {
    href: router.link('/{key}/{tab}', {
      path: {
        key: definition.stream.name,
        tab: 'overview'
      }
    }),
    background: false,
    content: /*#__PURE__*/_react.default.createElement(_stream_detail_overview.StreamDetailOverview, {
      definition: definition,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 16
      }
    }),
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.overviewTab', {
      defaultMessage: 'Overview'
    })
  },
  dashboards: {
    href: router.link('/{key}/{tab}', {
      path: {
        key: definition.stream.name,
        tab: 'dashboards'
      }
    }),
    background: true,
    content: /*#__PURE__*/_react.default.createElement(_stream_detail_dashboards_view.StreamDetailDashboardsView, {
      definition: definition,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 16
      }
    }),
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.dashboardsTab', {
      defaultMessage: 'Dashboards'
    })
  }
});
function isValidStreamDetailTab(value) {
  return ['overview', 'dashboards', 'significant_events'].includes(value);
}
function StreamDetailView() {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const {
    path
  } = (0, _use_streams_app_params.useStreamsAppParams)('/{key}/{tab}', true);
  const {
    key,
    tab
  } = path;
  const {
    definition
  } = (0, _use_stream_detail.useStreamDetailAsIngestStream)();
  const {
    features
  } = (0, _use_streams_privileges.useStreamsPrivileges)();
  if (tab === 'management') {
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
      path: "/{key}/management/{tab}",
      params: {
        path: {
          tab: 'retention'
        }
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 12
      }
    });
  }
  if (!isValidStreamDetailTab(tab)) {
    return /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
      path: "/{key}/{tab}",
      params: {
        path: {
          key,
          tab: 'overview'
        }
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 12
      }
    });
  }
  const tabs = features.significantEvents !== undefined ? getStreamDetailTabs({
    definition,
    router,
    features
  }) : undefined;
  const selectedTabObject = tabs === null || tabs === void 0 ? void 0 : tabs[tab];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.Header, {
    bottomBorder: "extended",
    description: /*#__PURE__*/_react.default.createElement(_description.StreamDescription, {
      definition: definition,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 22
      }
    }),
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      alignItems: "center",
      justifyContent: "spaceBetween",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 13
      }
    }, key, /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 15
      }
    }, _streamsSchema.Streams.ClassicStream.GetResponse.is(definition) && /*#__PURE__*/_react.default.createElement(_stream_badges.ClassicStreamBadge, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 70
      }
    }), _streamsSchema.Streams.WiredStream.GetResponse.is(definition) && /*#__PURE__*/_react.default.createElement(_stream_badges.WiredStreamBadge, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 68
      }
    }), /*#__PURE__*/_react.default.createElement(_stream_badges.LifecycleBadge, {
      lifecycle: definition.effective_lifecycle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_feedback_button.FeedbackButton, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 13
      }
    })),
    tabs: Object.entries(tabs !== null && tabs !== void 0 ? tabs : {}).map(([tabName, {
      label,
      href
    }]) => {
      return {
        label,
        href,
        isSelected: tab === tabName
      };
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "gear",
      href: router.link('/{key}/management/{tab}', {
        path: {
          key,
          tab: 'partitioning'
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.manageStreamLabel', {
      defaultMessage: 'Manage stream'
    }))],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate.Body, {
    color: selectedTabObject !== null && selectedTabObject !== void 0 && selectedTabObject.background ? 'plain' : 'subdued',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, selectedTabObject === null || selectedTabObject === void 0 ? void 0 : selectedTabObject.content));
}