"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoFeaturesEmptyState = NoFeaturesEmptyState;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _asset_image = require("../../asset_image");
var _use_ai_features = require("../add_significant_event_flyout/generated_flow_form/use_ai_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/empty_state/no_features.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function NoFeaturesEmptyState({
  onFeatureIdentificationClick,
  onManualEntryClick
}) {
  var _aiFeatures$genAiConn;
  const aiFeatures = (0, _use_ai_features.useAIFeatures)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
    type: "checklist",
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.significantEvents.noFeatures.title', {
    defaultMessage: 'Stream features missing'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center",
    css: {
      maxWidth: 480
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.streams.significantEvents.noFeatures.description', {
    defaultMessage: 'Feature identification generates logical subsets of the data in that stream. This is useful for generating better significant events.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "sparkles",
    fill: true,
    onClick: onFeatureIdentificationClick,
    disabled: !(aiFeatures !== null && aiFeatures !== void 0 && (_aiFeatures$genAiConn = aiFeatures.genAiConnectors) !== null && _aiFeatures$genAiConn !== void 0 && _aiFeatures$genAiConn.selectedConnector),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.significantEvents.noFeatures.featureIdentificationButtonLabel', {
    defaultMessage: 'Identify features'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onManualEntryClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.significantEvents.noFeatures.manualEntryButtonLabel', {
    defaultMessage: 'Manual entry'
  }))));
}