"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSignificantEventPreviewFetch = useSignificantEventPreviewFetch;
var _calculateAuto = require("@kbn/calculate-auto");
var _common = require("@kbn/data-plugin/common");
var _moment = _interopRequireDefault(require("moment"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_streams_app_fetch = require("../../../../hooks/use_streams_app_fetch");
var _default_query = require("../utils/default_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSignificantEventPreviewFetch({
  name,
  feature,
  kqlQuery,
  timeState,
  isQueryValid,
  noOfBuckets = 10
}) {
  const {
    dependencies: {
      start: {
        streams
      }
    }
  } = (0, _use_kibana.useKibana)();
  const previewFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(({
    signal
  }) => {
    var _calculateAuto$near;
    if (!isQueryValid) {
      return Promise.resolve(undefined);
    }
    const {
      from,
      to
    } = (0, _common.getAbsoluteTimeRange)(timeState.timeRange);
    const bucketSize = (_calculateAuto$near = _calculateAuto.calculateAuto.near(noOfBuckets, _moment.default.duration((0, _moment.default)(to).diff(from)))) === null || _calculateAuto$near === void 0 ? void 0 : _calculateAuto$near.asSeconds();
    const effectiveFeature = feature && feature.name === _default_query.NO_FEATURE.name ? undefined : feature;
    return streams.streamsRepositoryClient.fetch(`POST /api/streams/{name}/significant_events/_preview 2023-10-31`, {
      signal,
      params: {
        path: {
          name
        },
        query: {
          bucketSize: `${bucketSize}s`,
          from,
          to
        },
        body: {
          query: {
            kql: {
              query: kqlQuery
            },
            feature: effectiveFeature
          }
        }
      }
    });
  }, [isQueryValid, timeState.timeRange, noOfBuckets, feature, streams.streamsRepositoryClient, name, kqlQuery]);
  return previewFetch;
}